//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisMedia.m
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisMedia.h"


@implementation ElisMedia

// QuickTime X を試すためにかなり書き換えた。けど戻した。
- (id)initWithMovieFile:(NSString*)path
{
    image = nil;
    sound = nil;
    
    movie = [[QTMovie alloc] initWithFile:path error:nil];   
    [movie gotoBeginning];

    QTOpenGLTextureContextCreate(kCFAllocatorDefault,
                                 [[mainView openGLContext] CGLContextObj],
                                 [[mainView pixelFormat] CGLPixelFormatObj],
                                 NULL,			
                                 &textureContext);
        
    SetMovieVisualContext([movie quickTimeMovie], textureContext);
    
    attr = [NSDictionary dictionaryWithObjectsAndKeys:
            QTMovieFrameImageTypeCIImage, QTMovieFrameImageType,
#ifdef __SNOW_LEOPARD__
            [NSNumber numberWithBool:YES], QTMovieFrameImageSessionMode,  // 内部でキャッシュしろ
#endif
            [NSNumber numberWithBool:YES], QTMovieFrameImageHighQuality,  // 画質低下を許さない
            [movie attributeForKey:QTMovieNaturalSizeAttribute], QTMovieFrameImageSize, // 勝手にリサイズするな
            [NSNumber numberWithBool:NO], QTMovieFrameImageSingleField, // インターレース解除？
            nil];
    
    speed = 1.0;
    _path = path;
    playing = NO;
    
    [movie setVolume:0.0f];
    
    if([[NSWorkspace sharedWorkspace] type:[[NSWorkspace sharedWorkspace] typeOfFile:path error:nil] 
              conformsToType:@"com.apple.quartz-composer-composition"])
        isQuartz = YES;
    else
        isQuartz = NO;
    
    return self;
}

- (id)initWithImageFile:(NSString*)path
{
    movie = nil;
    textureContext = nil;
    sound = nil;
    text = nil;

    image = [[CIImage alloc] initWithContentsOfURL:[NSURL fileURLWithPath: path]];

    speed = 1.0;
    _path = path;
    return self;
}

- (id)initWithSoundFile:(NSString*)path
{
    movie = nil;
    image = nil;
    textureContext = nil;
    sound = [[QTMovie alloc] initWithFile:path error:nil];
    [sound setVolume:0.2]; // あまりにうるさい。
    speed = 1.0;
    _path = path;
    return self;
}

- (id)initWithText:(NSAttributedString*)t
{
    NSImage* im;
    movie = nil;
    sound = nil;
    text = [t copy];
//    [attr retain];
//    [attr setValue:[NSFont fontWithName:@"HiraKakuPro-W3" size:24.0f] forKey:NSFontAttributeName];
//    [attr setValue:[NSColor colorWithCalibratedRed:255 green:255 blue:255 alpha:255] forKey:NSForegroundColorAttributeName];
    NSRect size = [t boundingRectWithSize:NSMakeSize(4000, 3000) options:NSStringDrawingUsesLineFragmentOrigin];
    im = [[NSImage alloc] initWithSize:size.size];
    [im lockFocus];
//    t = [[NSAttributedString alloc] initWithString:@"string"];
    [[NSGraphicsContext currentContext] setShouldAntialias:YES];
    [t drawInRect:size];
    [im unlockFocus];
    image = [[CIImage alloc] initWithData:[im TIFFRepresentation]];
//    [im release];
    speed = 1.0;
    return self;
}

- (id)initWithQuartzFile:(NSString*)path
{
    return [self initWithMovieFile:path];
}    

// レガシーなので捨てました。
// もう一度試してる。
- (CIImage*)getFrameForTime:(CVTimeStamp*)timeStamp
{
    CVImageBufferRef currentFrame;
    CIImage* ret;
    
    if(movie){
        QTVisualContextCopyImageForTime(textureContext, NULL, timeStamp, &currentFrame);
        ret = [CIImage imageWithCVImageBuffer:currentFrame];
        CVOpenGLTextureRelease(currentFrame);
        return ret;
    }else if(image){
        return image;
    }
    return nil;
}

- (CIImage*)getFrameForQTTime:(QTTime)time
{
    // 64ビットでframeImageAtTimeメソッドは使えないみたい。どうしろと。
    time.timeValue *= speed;
    if(movie)
        return [movie frameImageAtTime:time withAttributes:attr error:nil];
    else if(image)
        return image;
    return nil;
}

- (void)releaseContext
{
    if(movie)
        QTVisualContextTask(textureContext);
}

- (void)setCurrentTime:(QTTime)time
{
    time.timeValue *= speed;
    if(movie){
        [movie setAttribute:[NSValue valueWithQTTime:time] forKey:QTMovieCurrentTimeAttribute];
        MoviesTask([movie quickTimeMovie], 0);
    }
    if(sound && !playing){
        [sound setCurrentTime:time];
        MoviesTask([sound quickTimeMovie], 0);
    }
}

- (void)play
{
    if(movie && !playing && usingStampMode){
//        [movie play];
        [movie setRate:speed];
        playing = YES;
    }
    if(sound && !playing){
        [sound play];
        playing = YES;
    }
}

- (void)stop
{
    if(movie && YES && usingStampMode){
        [movie stop];
        playing = NO;
    }
    if(sound && YES){
        [sound stop];
        playing = NO;
    }
}

- (QTTime)duration
{
    if(movie){
        if(isQuartz) return QTMakeTime(30, 1);
        QTTime d = [movie duration];
        d.timeValue /= speed;
        float s = (float)d.timeValue/d.timeScale;
        if(s > 60*10) return QTMakeTime(60*10, 1);
        return d;
    }
    if(sound)
        return [sound duration];
    if(image)
        return QTMakeTime(10, 1);
}

- (void)finalize
{
    if(movie){
        NSLog(@"movie finalize");
        [movie stop];
        SetMovieVisualContext([movie quickTimeMovie], NULL);
        movie = nil;
        CFRelease(textureContext);
    }
    
    [super finalize];
}

- (QTTrack*)getSoundTrack
{
    int size;
    NSArray* tracks;
    
    if(sound){
        tracks = [sound tracksOfMediaType:QTMediaTypeSound];
        size = [tracks count];
        if(size > 0) return [tracks objectAtIndex:0];
    }
    else if(image)
        return nil;
    
    return nil;
}

- (NSString*)type
{
    if(text)
        return @"text";
    if(image)
        return @"image";
    if(movie)
        return @"movie";
    if(sound)
        return @"sound";
    
    return @"other";
}

- (NSString*)path
{
    return _path;
}

- (void)encodeWithCoder:(NSCoder*)encoder
{
    int flag;
    [encoder encodeObject:_path forKey:@"path"];
    [encoder encodeObject:text forKey:@"text"];
    [encoder encodeFloat:speed forKey:@"speed"];
    
    if(movie) flag = 0;
    else if(sound) flag = 1;
    else if(text) flag = 3;
    else if(image) flag = 2;
    
    [encoder encodeInt:flag forKey:@"flag"];
}

- (id)initWithCoder:(NSCoder*)coder
{
    int flag;
    NSString* path = [coder decodeObjectForKey:@"path"];
    NSAttributedString* t = [coder decodeObjectForKey:@"text"];
    flag =  [coder decodeIntForKey:@"flag"];
    
    id ret;
    
    if(flag == 0)
        ret = [self initWithMovieFile:path];
    else if(flag == 1)
        ret = [self initWithSoundFile:path];
    else if(flag == 2)
        ret = [self initWithImageFile:path];
    else
        ret = [self initWithText:t];
    
    speed = [coder decodeFloatForKey:@"speed"];
    
    return ret;
}

- (QTMovie*)getSoundMovie
{
    if(sound)
        return sound;
    else
        return nil;
}

- (NSAttributedString*)text
{
    return text;
}

- (void)setText:(NSAttributedString*)t
{
    [self initWithText:t];
}

- (NSRect)size
{
    if(sound)
        return NSZeroRect;
    if(movie){
        NSSize s;
        s = [[movie attributeForKey:QTMovieCurrentSizeAttribute] sizeValue];
        return NSMakeRect(0, 0, s.width, s.height);
    }
    if(image){
        CGRect c = [image extent];
        return *(NSRect*)&c;
    }
}

- (float)speed
{
    return speed;
}

- (void)setSpeed:(float)s
{
    speed = s;
}

- (void)setVolume:(float)v
{
    [sound setVolume:v];
}

- (BOOL)isQuartz
{
    return isQuartz;
}

@end
