//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisWriter.m
//  Elis Colors
//
//  Created by 柳 on 09/09/17.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisWriter.h"
#import "ElisController.h"

@implementation ElisWriter

- (void)awakeFromNib
{
    fps = 30;
    imageCodec = @"pxlt"; // 8BPS rle pxlt 見つけたぞーッ！ pxltの圧縮率マジ最高！！
    imageQuality = [NSNumber numberWithLong:codecLosslessQuality];
    gamma_table = malloc(sizeof(unsigned char) * 256);
}

- (void)write:(NSString*)path
{
    int frame, i, size, totalFrames;
    NSImage* image;
    float seconds;
    int w, h;
    unsigned char *buffer, *pixels;
    QTTime now;
    NSRect rect;
    NSBitmapImageRep* rep;
    
    [self initializeMovie:path];
    seconds = [_mainController getHipTime];
    totalFrames = seconds * fps;
    w = ProjectMovieSize.size.width;
    h = ProjectMovieSize.size.height;
    rect = *(NSRect*)&ProjectMovieSize;
    
    buffer = malloc(w*h*3*sizeof(unsigned char));
    pixels = malloc(w*h*3*sizeof(unsigned char));
    
    attrs = [NSDictionary dictionaryWithObjectsAndKeys:imageCodec, QTAddImageCodecType,
             imageQuality, QTAddImageCodecQuality, 
             nil];
    
    [self readyGammmaTable];
    
    // プログレスバーを表示
    [NSApp beginSheet:_barSheet modalForWindow:_mainWindow
        modalDelegate:self didEndSelector:nil contextInfo:NULL];
    
    
    for(frame = 1; frame < totalFrames; frame++){
        now = QTMakeTime(frame, fps);
        [_mainView getFrameForQTTime:now];
        [_mainView getCurrentPixelData:rect buffer:buffer];
        
        for(i = 0; i < h; i++) // 富豪的に上下反転。テラ強引
            memcpy(&pixels[i*w*3], &buffer[(h-1-i)*w*3], w*3*sizeof(unsigned char));
        
        [self gammaAdjust:pixels size:w*h*3]; // 色味がシフトする分をガンマ補正。これはひどい。
        
        rep = [[NSBitmapImageRep alloc] // RGB RGB RGB ... なバイト列からBitMapImageRepをつくる。
               initWithBitmapDataPlanes:&pixels
               pixelsWide:w
               pixelsHigh:h
               bitsPerSample:8
               samplesPerPixel:3
               hasAlpha:NO
               isPlanar:NO
               colorSpaceName:NSCalibratedRGBColorSpace
               bitmapFormat:NSAlphaNonpremultipliedBitmapFormat
               bytesPerRow:w*3 
               bitsPerPixel:24];
        
        image = [[NSImage alloc] init];
        [image addRepresentation:rep];
        [self performSelectorOnMainThread:@selector(addImage:) withObject:image waitUntilDone:YES];
//        [outputMovie addImage:image forDuration:QTMakeTime(1, fps) withAttributes:attrs];
        [self performSelectorOnMainThread:@selector(changeBarValue:) 
                               withObject:[NSNumber numberWithDouble:(double)frame/totalFrames] waitUntilDone:YES];
        
        if([outputMovie canUpdateMovieFile])
            [outputMovie updateMovieFile];
        
        NSLog(@"%d / %d", frame, totalFrames);
    }
    
    free(buffer);
    free(pixels);
    
    [self addSoundTrack];
    
    [outputMovie setVolume:0.2];
    [outputMovie updateMovieFile];
    
    [_barSheet close];
    [NSApp endSheet:_barSheet];
}

- (void)addImage:(id)image
{
    [outputMovie addImage:image forDuration:QTMakeTime(1, fps) withAttributes:attrs];
}

- (void)initializeMovie:(NSString*)path
{
    outputMovie = [[QTMovie alloc] initToWritableFile:path error:nil];
}

- (void)changeBarValue:(NSNumber*)v
{
    [_bar setDoubleValue:[v doubleValue]];
}

- (void)addSoundTrack
{
    NSMutableArray* soundTrack = [[NSMutableArray alloc] init];
    QTTrack* track;
    int i, size;
    QTTime offset;
    QTTimeRange mapping;
    
    [_mainController getSoundTrack:soundTrack];
    size = [soundTrack count];
    
    for(i = 0; i < size; i += 3){
        track = [soundTrack objectAtIndex:i];
        offset = [[soundTrack objectAtIndex:i+1] QTTimeValue];
        mapping = [[soundTrack objectAtIndex:i+2] QTTimeRangeValue];
        [outputMovie insertSegmentOfTrack:track timeRange:QTMakeTimeRange(offset, mapping.duration) atTime:mapping.time];
    }
}

- (void)finalize
{
    free(gamma_table);
    [super finalize];
}

- (void)readyGammmaTable
{
    int i;
    
    for(i = 0; i < 256; i++)
        gamma_table[i] = (unsigned char)255.0 * pow(i/255.0, 1.0/GAMMA);
}

- (void)gammaAdjust:(unsigned char*)pixels size:(int)s
{
    int i;
    for(i = 0; i < s; i++)
        pixels[i] = gamma_table[pixels[i]];
}

@end
