/*
# mrcImageShapeSearch : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrcImageShapeSearch
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"

typedef struct lmrcImageShapeSearchInfo {
	int radius; // Sylinder
	int minRadius;
	int maxRadius;
	int length; // Sylinder
	int minLength;
	int maxLength;

	float minTheta;
	float maxTheta;
	float delTheta;
	float minPhi;
	float maxPhi;
	float delPhi;
	float minPsi;
	float maxPsi;
	float delPsi;

	mrcImage shape;
} lmrcImageShapeSearchInfo;

typedef enum lmrcImageShapeSearchMode {
	lmrcImageShapeSearchModeSylinder=0
} lmrcImageShapeSearchMode;

extern void	lmrcImageShapeSearch(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode);
extern void	lmrcImageShapeSearchSylinder(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode);
extern void lmrcImageShapeSearchModePrint(FILE* fpt);

int
main(int argc, char* argv[]) 
{
	mrcImageShapeSearchInfo info;
	lmrcImageShapeSearchInfo linfo;
	mrcImage in;
	mrcImage out;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	linfo.minRadius = info.minR;
	linfo.maxRadius = info.maxR;
	linfo.minLength = info.minL;
	linfo.maxLength = info.maxL;

	linfo.minPhi   = info.minPhi*RADIAN;
	linfo.maxPhi   = info.maxPhi*RADIAN;
	linfo.delPhi   = info.delPhi*RADIAN;
	linfo.minTheta = info.minTheta*RADIAN;
	linfo.maxTheta = info.maxTheta*RADIAN;
	linfo.delTheta = info.delTheta*RADIAN;

	mrcFileRead(&in, info.In, "in main", 0); 

	lmrcImageShapeSearch(&out, &in, &linfo, info.mode);

	mrcFileWrite(&out, info.Out, "in main", 0);
	mrcFileWrite(&linfo.shape, info.Shape, "in main", 0);

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
	lmrcImageShapeSearchModePrint(stderr);
}

void
lmrcImageShapeSearchModePrint(FILE* fpt)
{
	fprintf(fpt, "%d: Cylinder with radius and length\n", lmrcImageShapeSearchModeSylinder);
}


void
lmrcImageShapeSearch(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode)
{
	switch(mode) {
		case lmrcImageShapeSearchModeSylinder: {
			lmrcImageShapeSearchSylinder(out, in, linfo, mode);
			break;
		}
		default: {
			fprintf(stderr, "Not supported mode: %d\n", mode);
			break;
		}
	}
}


void
lmrcImageShapeSearchSylinder(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode)
{
	float x, y, z;
	float theta, phi, psi;
	int iPhi, iTheta, iPsi;	
	int nPhi, nTheta, nPsi;	
	int iR;

	nPhi   = (int)((linfo->maxPhi  -linfo->minPhi)  /linfo->delPhi)  +1;
	nTheta = (int)((linfo->maxTheta-linfo->minTheta)/linfo->delTheta)+1;
	nPsi   = 2*M_PI/linfo->delPsi;

	for(z=0; z<in->HeaderN.z; z++) {
	for(y=0; y<in->HeaderN.y; y++) {
	for(x=0; x<in->HeaderN.x; x++) {
		for(iTheta=0; iTheta<nTheta; iTheta++) {	
			theta = linfo->minTheta + iTheta*linfo->delTheta;
		for(iPhi=0; iPhi<nPhi; iPhi++) {	
			phi = linfo->minPhi + iPhi*linfo->delPhi;
			for(iR=linfo->minRadius; iR<=linfo->maxRadius; iR++) {
				
			}
		}
		}
	}
	}
	}
}

