#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h> 
#include <vtk.h>  
#include <pdbFile.h>        
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
//#include "vtkGraphicsFactory.h"

#include "eosInteractorMyStyle.cc"


#define SPHERERADIUS          0.03
#define SPHERETHETARESOLUTION 30
#define SPHEREPHIRESOLUTION   30 
#define SPHERECOLORR          1.0 
#define SPHERECOLORG          0.0  
#define SPHERECOLORB          1.0 
#define SPHEREOPACITY         0.2 
#define CONEHEIGHT           1.0
#define CONERADIUS           0.5
#define CONERESOLUTION       80

class eosStereoWindow{

  public:
         vtkRenderer     *ren,*renLeft,*renRight;
         vtkCamera       *cam,*camLeft,*camRight;
         vtkLight        *light;
         vtkRenderWindow *renWin1,*renWin2;
         vtkRenderWindowInteractor *iren1,*iren2;

         int i;
         eosStereoWindow();
         void init();
         static eosStereoWindow* New();
         void eosStereoWindowSet(vtkActor*,int);
         void run(int);
         vtkRenderer* GetRenderer(void);
	 eosInteractorMyStyle *myi,*myi2;
};

eosStereoWindow::eosStereoWindow(){
         init();
}

void eosStereoWindow::init(){

         cam=vtkCamera::New();
	 cam->SetFocalPoint(0,0,0);
	 cam->SetPosition(0,0,10);
	 cam->SetEyeAngle(10.0);
	 camLeft=vtkCamera::New();
	 camLeft->SetFocalPoint(0,0,0);
	 camLeft->SetPosition(0,0,10);
	 camLeft->SetEyeAngle(10.0);
	 camRight=vtkCamera::New();
	 camRight->SetFocalPoint(0,0,0);
	 camRight->SetPosition(0,0,10);
	 camRight->SetEyeAngle(10.0);

	 light=vtkLight::New();
	 light->SetFocalPoint(0.21406,1.5,0);
	 light->SetPosition(8.3761,4.94858,4.1250);

}


void eosStereoWindow::eosStereoWindowSet(vtkActor* eosActor,int flag){

         ren=vtkRenderer::New();
	 ren->SetActiveCamera(cam);
	 ren->AddLight(light);
	 ren->AddActor(eosActor);

	 if(flag==1){
	   renLeft=vtkRenderer::New();
	   renRight=vtkRenderer::New();

	   renLeft->SetViewport(0,0,0.5,1.0);
	   renLeft->SetActiveCamera(camLeft);
	   renLeft->AddLight(light);
	   renLeft->AddActor(eosActor);

	   renRight->SetViewport(0.5,0,1.0,1.0);
	   renRight->SetActiveCamera(camRight);
	   renRight->AddLight(light);
	   renRight->AddActor(eosActor);
	 }

	 renWin1=vtkRenderWindow::New();
	 renWin1->AddRenderer(ren);
	 renWin1->SetWindowName("eosStereoWindow");
	 renWin1->SetSize(300,300);
	 
	if(flag==1){
	   renWin2=vtkRenderWindow::New();
	   renWin2->AddRenderer(renLeft);
	   renWin2->AddRenderer(renRight);
	   renWin2->SetStereoType(5);
	   renWin2->SetWindowName("eosStereoWindow2");
	   renWin2->SetSize(600,300);
	 }

	 myi=eosInteractorMyStyle::New();
	 myi2=eosInteractorMyStyle::New();

	 iren1=vtkRenderWindowInteractor::New();
	 iren1->SetRenderWindow(renWin1);
	 iren1->SetInteractorStyle(myi);
	 

	 if(flag==1){

	   iren2=vtkRenderWindowInteractor::New();
	   iren2->SetRenderWindow(renWin2);
	   iren2->SetInteractorStyle(myi2);

	   myi->SetRenderWindows(ren,renLeft,renRight,iren1,iren2);
	   myi2->SetRenderWindows(ren,renLeft,renRight,iren1,iren2);

	 }


}

void eosStereoWindow::run(int flag){

  	 renWin1->Render();
	 if(flag==1){
	   renWin2->Render();
	 }

	 iren1->Start();
	 if(flag==1){
	   iren2->Start();
	 }
  
}

vtkRenderer* eosStereoWindow::GetRenderer(void){
        return(ren);
}

int main(int argc, char* argv[])
{
	mrcViewInfo info;
	pdbFile pdb;
	int flag;

	init0(&info);
    	argCheck(&info, argc, argv);
    	init1(&info);

	DEBUGPRINT("Program Start\n");   

	flag=1;

	vtkConeSource *cone=vtkConeSource::New();
	 cone->SetHeight(CONEHEIGHT);
	 cone->SetRadius(CONERADIUS);
	 cone->SetResolution(CONERESOLUTION);
	vtkPolyDataMapper *coneMapper=vtkPolyDataMapper::New();
	 coneMapper->SetInput(cone->GetOutput());
	vtkActor *coneActor=vtkActor::New();
	 coneActor->SetMapper(coneMapper);
	 coneActor->GetProperty()->SetColor(0.0,0.0,1.0);
	 coneActor->RotateZ(0.0);
	 coneActor->SetPosition(0.0,0.0,0.0);
	 coneActor->RotateY(0.0);

	eosStereoWindow stereoWin;
	stereoWin.eosStereoWindowSet(coneActor,flag);
	stereoWin.run(flag);
                                                  
	exit(EXIT_SUCCESS);
}


void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
