'use strict';

var _ = require('lodash');
var glob   = require('glob');
var path   = require('path');
var remove = require('remove');

function setOptions(workspace) {
    var options = {
        tmpDir    : __dirname + '/../../workspace/' + workspace + '/tmp',
        uploadDir : __dirname + '/../../workspace/' + workspace + '/files',
        uploadUrl : '/' + workspace + '/files/',
        strage    : {
            type : 'local'
        } 
    }
    return options;
};

exports.singleton = function() {

    var list = [];

    this.create = function (req, res) {
        var options = setOptions(req.params.workspace);
        var uploader = require('blueimp-file-upload-expressjs')(options);
        uploader.get(req, res, function (obj) {
            res.send(JSON.stringify(obj));
        });
    };

    this.post = function (req, res) {
        var options = setOptions(req.params.workspace);
        var uploader = require('blueimp-file-upload-expressjs')(options);
        uploader.post(req, res, function (obj) {
            res.send(JSON.stringify(obj));
            if (obj.files[0] != undefined) {
                list.push(obj.files[0].name);
            }
        });
    };

    this.read = function (req, res) {
        return list;
    };

    this.update = function(req, res) {
        var wsPath = __dirname + "/../../workspace/" + req.params.workspace + "/files/*";
        console.log(wsPath);
        var fullPath = glob.sync(wsPath);
        list = fullPath.map(path.basename);
        res.send(["updated"]);
    };

    this.delete = function (req, res) {
        var filePath = __dirname + "/../../workspace/" + req.params.workspace + "/files/" + req.params.name;

        remove(filePath, function (err) {
            if (err) {
                console.error(err);
                res.send(["Error"]);
            } else {
                console.log("File removal successed");
                list.some(function (value, index) {
                    if (value == path.basename(filePath)) {
                        list.splice(index, 1);
                    }
                });
                res.send(["Success"]);
            }
        });
    };
};
