require "./option"
require "json"

EosHome           = ENV["EOS_HOME"]
EosSrc            = EosHome + "/src/Tools/"
JSONDirPath       = ENV["HOME"] + "/Zephyr/server/json/"
CommandOptionPath = JSONDirPath + "option/"
CommandListPath   = JSONDirPath + "command_list.json"
TagListPath       = JSONDirPath + "tag_list.json"
ErrorLogPath      = JSONDirPath + "error_log.json"

error_logs    = Hash.new
command_lists = Array.new
class_names   = Dir.glob("#{EosSrc}*").sort
tag_list      = Array.new
tag_list.push("all")

#For Debug
#count = 0

class_names.each do |class_path|
    class_name = File.basename(class_path)

    if (class_name == "Makefie" ||
        class_name == "Makefile.orig" ||
        class_name == "Config") then
        next
    end

    command_names = Dir.glob("#{class_path}/*").sort

    command_names.each do |command_path|
        command_name = File.basename(command_path)
        if (command_name=="Makefile"||
            command_name=="Makefile.orig"||
            command_name=="Config"
            command_name == "Makefile.org"  ||
                command_name == "q") then
            next
        end

        #success Hash  {option->option ,tag->tag}
        #error   Array [option_path,ex.class]
        #タグがとれるようになったら、
        #create_json_file.rbとoption.rbを書き換える
        result = Option.csv2hash(command_path)
        #tag    = result[:tag]

        if result.class.to_s == "Hash"
            # print "OK\n"
            option = result[:option]
            json_name = CommandOptionPath + "#{command_name}.json"
            json = JSON.pretty_generate(option)

            #write to ~/json/option/
            open(json_name,"w") do |fh|
                fh.write(json)
            end

            #prepare for ~/json/command_list.json
            tmp = Hash.new
            tmp[:name] = command_name
            tmp[:tags]  = Array.new 
            tmp[:tags].push("all")
            tmp[:tags].push(class_name)
            command_lists.push(tmp)

            if !tag_list.include?(class_name)
                tag_list.push(class_name)
            end

        elsif result.class.to_s == "Array"
            error = Hash.new
            error["path"]    = result[0]
            error["error"]   = result[1]
            error_logs[command_name] = error
        else 
            print "Unexpected Error Occured!\n"
        end
    end 
    #break
end

#Write to ~/json/command_list.json
json = JSON.pretty_generate(command_lists)
open(CommandListPath,"w") do |fh|
    fh.write(json)
end

#Write to ~/json/error_log.json
json = JSON.pretty_generate(error_logs)
open(ErrorLogPath,"w") do |fh|
    fh.write(json)
end

##write to ~/json/tag_list.json
json = JSON.pretty_generate(tag_list)
open(TagListPath,"w") do |fh|
    fh.write(json)
end

