require 'csv'
require 'json'

module Option
    def csv2hash(command_path)
        #command_name = File.basename(command_path)
        option_path = "#{command_path}/Config/OptionControlFile"

        # option[0] = about -i, 
        # option[1] = about -o, 
        # option[3] = about -m, .... etc 
        option = Array.new
        index  = 0
        begin
            CSV.foreach(option_path) do |ref| 
                if ref[0] =~ /^#/ 
                    next
                end

                # [{argIndex: ,argName: ,argType: ,initialValue: },{.,.}.,.{.,.}]
                optionNumber = ref[4].to_s.to_i

                if optionNumber != 0
                    option[index]                     = Hash.new{|i|{}}
                    option[index]["option"]           = ref[0].to_s
                    option[index]["fullOption"]       = ref[1]
                    option[index]["optionName"]       = ref[2]
                    option[index]["optionProperties"] = ref[3].to_s == "Essential"
                    option[index]["optionNumber"]     = ref[4].to_s.to_i


                    option[index]["arg"]              = Array.new(option[index]["optionNumber"]){|i|{}} 

                    option[index]["arg"].each_with_index do |arg,i|
                        arg["argIndex"]      = ref[4*(i+1)+1].to_s
                        arg["argName"]       = ref[4*(i+1)+2].to_s
                        argType              = ref[4*(i+1)+3].to_s.split('::')  #argType{ inFile::mrcImage::ASCII } and so on
                        arg["argType"]       = argType.shift                    #arg["argType"]   = inFile | outFile | appendFile ...
                        arg["attribute"] = argType.empty? ? nil : argType       #arg["attribute"] = [ mrcImage,ASCII,... ]
                        arg["initialValue"] = ref[4*(i+1)+4].to_s

                        case arg["argType"]
                        when "inFile","inFileList","inFileListNoOpen" then
                            arg["formType"] = "select"
                        when "outFile","outFileList","appendFile","appendFileList","Character","String","StringAll" then
                            arg["formType"] = "text"
                        when "Integer","Real" then
                            arg["formType"] = "number"
                        else 
                            arg["formType"] = nil
                        end

                        if (arg["initialValue"] == "NULL"||
                            arg["initialValue"] == "stdout") then
                            arg["initialValue"] = ""
                        end
                    end
                    index += 1
                end
            end
            #tag = nil
            success = Hash.new
            success[:option] = option
            #success["tag"] = tag
            return success
        rescue => ex
            return option_path,ex.class
        end
    end
    module_function :csv2hash
end
