namespace app {
    'use strict';

    var appName = 'zephyr';
    export var zephyr = angular.module(appName, ['ui.router', 'ngResource', 'ui.bootstrap']);


    zephyr.config(($stateProvider, $urlRouterProvider, $locationProvider) => {

        $urlRouterProvider.otherwise('/execution');

        $locationProvider.html5Mode({
            enabled: true,
            requireBase: false
        });

        $stateProvider
            .state('execution', {
                url: '/execution',
                templateUrl: 'templates/execution.html',
                controller: 'executionController',
                controllerAs: 'c'
            })
        .state('workspace', {
            url: '/workspace',
            templateUrl: 'templates/workspace.html',
            controller: 'workspaceController',
            controllerAs: 'c'
        })
        .state('history', {
            url: '/history',
            templateUrl: 'templates/history.html',
            controller: 'historyController',
            controllerAs: 'c'
        })
    });

    zephyr.service('APIEndPoint', services.APIEndPoint);
    zephyr.service('MyModal', services.MyModal);
    zephyr.service('WebSocket', services.WebSocket);


    zephyr.filter('Tag', filters.Tag);
    zephyr.controller('selectCommandController', controllers.SelectCommand);
    zephyr.controller('previewController', controllers.Preview);


    zephyr.controller('executionController', controllers.Execution);
    zephyr.controller('workspaceController', controllers.Workspace);
    zephyr.controller('historyController', controllers.History);

    zephyr.controller('commandController', directives.CommandController);
    zephyr.controller('optionController', directives.OptionController);
    zephyr.controller('directoryController', directives.DirectoryController);
    zephyr.controller('HeaderMenuController', directives.HeaderMenuController);

    zephyr.directive('headerMenu', directives.HeaderMenu.Factory());
    zephyr.directive('command', directives.Command.Factory());
    zephyr.directive('option', directives.Option.Factory());
    zephyr.directive('directory', directives.Directory.Factory());

}
