var gulp = require('gulp');
var sass = require('gulp-sass');
var webpack = require('webpack-stream');

var dist = __dirname + '/dist/';

gulp.task('ts', function() {
    return gulp.src('app/scripts/entry.js')
    .pipe(webpack( require('./webpack.config.js') ))
    .pipe(gulp.dest(dist));
});

gulp.task('html', function() {
    return gulp.src('./app/index.html')
    .pipe(gulp.dest(dist));
});

gulp.task('sass', function() {
    return gulp.src('./app/style.scss')
    .pipe(sass())
    .pipe(gulp.dest(dist + 'css/'));
});

gulp.task('templates', function() {
    return gulp.src('./app/templates/*')
    .pipe(gulp.dest(dist + 'templates/'));
});

gulp.task('watch-ts', function() {
    gulp.watch('./app/**/*.ts', ['ts']);
});

gulp.task('watch-html', function() {
    gulp.watch('./app/index.html', ['html']);
});

gulp.task('watch-templates', function() {
    gulp.watch('./app/templates/*', ['templates'])
});

gulp.task('watch-sass', function() {
    gulp.watch('./app/style.scss', ['sass'])
});

gulp.task('default', ['ts', 'html', 'sass', 'templates', 'watch-ts', 'watch-html', 'watch-templates', 'watch-sass']);
