#!/usr/bin/env node --harmony

'use strict';

var express = require('express');
var config  = require('./config');
var app     = express();
var EventEmitter = require('events').EventEmitter;
var emitter = new EventEmitter;
var server  = require('http').Server(app)
var ioServer = require('socket.io');
var ws = require('./class/WebSocket').instance;

require('./express')(app);
require('./routes')(app);

// DBのコンストラクタを実行
var DB = require('./class/DB').instance;
DB.init()
.then(function() {
    return DB.test2();
})
.then(function() {
    if(process.env.NODE_ENV === 'debug') {
        return DB.testRest();
    }
})
.then(function() {
    var server = app.listen(config.port, config.ip, function () {
        console.log('Zephyr listening at http://%s:%s', config.ip, config.port);
        console.log('NODE_ENV = ' + app.get('env'))
    });

    var io = ioServer.listen(server);
    ws.connect(io);
});

exports = module.exports = app;
