/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.grammar.GrammarSchemaLess;
import com.siemens.ct.exi.grammar.XSDGrammarBuilder;
import java.io.InputStream;

public class GrammarFactory {
    private static XSDGrammarBuilder grammarBuilder = XSDGrammarBuilder.newInstance();

    protected GrammarFactory() {
    }

    public static GrammarFactory newInstance() {
        return new GrammarFactory();
    }

    public Grammar createGrammar(String xsdLocation) throws EXIException {
        if (xsdLocation == null || xsdLocation.equals("")) {
            throw new EXIException("SchemaLocation not specified correctly!");
        }
        return grammarBuilder.build(xsdLocation);
    }

    public Grammar createGrammar(InputStream is) throws EXIException {
        return grammarBuilder.build(is);
    }

    public Grammar createSchemaLessGrammar() {
        return new GrammarSchemaLess();
    }
}

