/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXICoder;
import com.siemens.ct.exi.core.EXIHeader;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.Characters;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.io.block.DecoderBlock;
import com.siemens.ct.exi.io.channel.BitDecoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public abstract class AbstractEXIDecoder
extends AbstractEXICoder
implements EXIDecoder {
    protected Event nextEvent;
    protected EventType nextEventType;
    protected int ec;
    protected InputStream is;
    protected DecoderBlock block;
    protected String elementURI;
    protected String elementLocalName;
    protected String elementPrefix;
    protected String attributeURI;
    protected String attributeLocalName;
    protected String attributePrefix;
    protected String attributeValue;
    protected String xsiTypeUri;
    protected String xsiTypeName;
    protected boolean xsiNil;
    protected String xsiNilDeviation;
    protected String characters;
    protected String docTypeName;
    protected String docTypePublicID;
    protected String docTypeSystemID;
    protected String docTypeText;
    protected String entityReferenceName;
    protected String comment;
    protected String nsURI;
    protected String nsPrefix;
    protected String piTarget;
    protected String piData;
    protected boolean preservePrefixes;

    public AbstractEXIDecoder(EXIFactory exiFactory) {
        super(exiFactory);
        this.preservePrefixes = exiFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES");
    }

    protected void initForEachRun() throws EXIException {
        super.initForEachRun();
        try {
            this.block = this.exiFactory.createDecoderBlock(this.is);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void setInputStream(InputStream is, boolean exiBodyOnly) throws EXIException {
        this.is = is;
        if (!(is instanceof BufferedInputStream)) {
            this.is = new BufferedInputStream(is);
        }
        if (!exiBodyOnly) {
            BitDecoderChannel headerChannel = new BitDecoderChannel(is);
            EXIHeader.parse(headerChannel);
        }
        this.initForEachRun();
    }

    protected void decodeEventCode() throws EXIException {
        this.ec = this.decode1stLevelEventCode();
        if (this.ec == -1) {
            int ec2 = this.decode2ndLevelEventCode();
            if (ec2 == -1) {
                int ec3 = this.decode3rdLevelEventCode();
                this.nextEventType = this.currentRule.get3rdLevelEvent(ec3, this.fidelityOptions);
                this.nextEvent = null;
            } else {
                this.nextEventType = this.currentRule.get2ndLevelEvent(ec2, this.fidelityOptions);
                if (this.nextEventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                    this.updateInvalidValueAttribute();
                } else {
                    this.nextEvent = null;
                }
            }
        } else {
            this.nextEvent = this.currentRule.get1stLevelEvent(this.ec);
            this.nextEventType = this.nextEvent.getEventType();
        }
    }

    protected void updateInvalidValueAttribute() throws EXIException {
        int ec3AT;
        SchemaInformedRule sir = (SchemaInformedRule)this.currentRule;
        try {
            ec3AT = this.block.readEventCode(MethodsBag.getCodingLength(sir.getNumberOfSchemaDeviatedAttributes()));
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
        if (ec3AT < sir.getNumberOfSchemaDeviatedAttributes() - 1) {
            this.ec = ec3AT + sir.getLeastAttributeEventCode();
            this.nextEvent = this.currentRule.get1stLevelEvent(this.ec);
        } else if (ec3AT == sir.getNumberOfSchemaDeviatedAttributes() - 1) {
            this.nextEventType = EventType.ATTRIBUTE_XSI_NIL_DEVIATION;
        } else {
            throw new EXIException("Error occured while decoding deviated attribute");
        }
    }

    protected int decode1stLevelEventCode() throws EXIException {
        try {
            int level1 = this.block.readEventCode(this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions));
            if (this.currentRule.hasSecondOrThirdLevel(this.fidelityOptions)) {
                return level1 == this.currentRule.getNumberOfEvents() ? -1 : level1;
            }
            return level1;
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected int decode2ndLevelEventCode() throws EXIException {
        try {
            int ch2 = this.currentRule.get2ndLevelCharacteristics(this.fidelityOptions);
            int level2 = this.block.readEventCode(MethodsBag.getCodingLength(ch2));
            if (this.currentRule.get3rdLevelCharacteristics(this.fidelityOptions) > 0) {
                return level2 < ch2 - 1 ? level2 : -1;
            }
            return level2 < ch2 ? level2 : -1;
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected int decode3rdLevelEventCode() throws EXIException {
        try {
            int ch3 = this.currentRule.get3rdLevelCharacteristics(this.fidelityOptions);
            return this.block.readEventCode(MethodsBag.getCodingLength(ch3));
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeStartDocumentStructure() throws EXIException {
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
    }

    protected String decodeQNamePrefix(String uri) throws EXIException {
        try {
            Enumeration<String> validPrefixes;
            String prefix = null;
            if (this.preservePrefixes && (validPrefixes = this.namespaces.getPrefixes(uri)).hasMoreElements()) {
                int numberOfPrefixes = 0;
                do {
                    validPrefixes.nextElement();
                    ++numberOfPrefixes;
                } while (validPrefixes.hasMoreElements());
                if (numberOfPrefixes > 1) {
                    int id = this.block.readEventCode(MethodsBag.getCodingLength(numberOfPrefixes));
                    Enumeration<String> validPrefixes2 = this.namespaces.getPrefixes(uri);
                    while (id != 0) {
                        validPrefixes2.nextElement();
                        --id;
                    }
                    prefix = validPrefixes2.nextElement();
                }
            }
            return prefix;
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeStartElementStructure() throws EXIException {
        this.elementURI = ((StartElement)this.nextEvent).getNamespaceURI();
        this.elementLocalName = ((StartElement)this.nextEvent).getLocalPart();
        this.elementPrefix = this.decodeQNamePrefix(this.elementURI);
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
        this.pushRule(this.elementURI, this.elementLocalName);
        this.pushScope(this.elementURI, this.elementLocalName);
    }

    protected void decodeStartElementGenericStructure() throws EXIException {
        this.decodeStartElementExpandedName();
        this.elementPrefix = this.decodeQNamePrefix(this.elementURI);
        Rule tmpStorage = this.currentRule;
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
        tmpStorage.learnStartElement(this.elementURI, this.elementLocalName);
        this.pushRule(this.elementURI, this.elementLocalName);
        this.pushScope(this.elementURI, this.elementLocalName);
    }

    protected void decodeStartElementGenericUndeclaredStructure() throws EXIException {
        this.decodeStartElementExpandedName();
        this.elementPrefix = this.decodeQNamePrefix(this.elementURI);
        this.currentRule.learnStartElement(this.elementURI, this.elementLocalName);
        this.replaceRuleAtTheTop(this.currentRule.getElementContentRuleForUndeclaredSE());
        this.pushRule(this.elementURI, this.elementLocalName);
        this.pushScope(this.elementURI, this.elementLocalName);
    }

    protected void decodeStartElementExpandedName() throws EXIException {
        try {
            this.elementURI = this.block.readUri();
            this.elementLocalName = this.block.readLocalName(this.elementURI);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void pushScope(String uri, String localName) {
        super.pushScope(uri, localName);
        this.elementPrefix = null;
    }

    protected void decodeNamespaceDeclarationStructure() throws EXIException {
        try {
            this.nsURI = this.block.readUri();
            this.nsPrefix = this.block.readPrefix(this.nsURI);
            boolean local_element_ns = this.block.readBoolean();
            if (local_element_ns) {
                this.elementPrefix = this.nsPrefix;
            }
            this.namespaces.declarePrefix(this.nsPrefix, this.nsURI);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected Attribute decodeAttributeStructure() throws EXIException {
        Attribute at = (Attribute)this.nextEvent;
        this.attributeURI = at.getNamespaceURI();
        this.attributeLocalName = at.getLocalPart();
        this.attributePrefix = this.decodeQNamePrefix(this.attributeURI);
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
        return at;
    }

    protected void decodeAttributeGenericStructure() throws EXIException {
        this.decodeAttributeGenericUndeclaredStructure();
        this.attributePrefix = this.decodeQNamePrefix(this.attributeURI);
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
    }

    protected void decodeAttributeGenericUndeclaredStructure() throws EXIException {
        try {
            this.attributeURI = this.block.readUri();
            this.attributeLocalName = this.block.readLocalName(this.attributeURI);
            this.attributePrefix = this.decodeQNamePrefix(this.attributeURI);
            if (!this.attributeURI.equals("http://www.w3.org/2001/XMLSchema-instance") || !this.attributeLocalName.equals("nil") && !this.attributeLocalName.equals("type")) {
                this.currentRule.learnAttribute(this.attributeURI, this.attributeLocalName);
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeAttributeXsiType() throws EXIException {
        try {
            this.xsiTypeUri = this.block.readUri();
            this.xsiTypeName = this.block.readLocalName(this.xsiTypeUri);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeAttributeXsiNil() throws EXIException {
        try {
            this.xsiNil = this.block.readBoolean();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeAttributeXsiNilDeviation() throws EXIException {
        try {
            this.xsiNilDeviation = this.block.readString();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected Characters decodeCharactersStructure() throws IOException {
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
        return (Characters)this.nextEvent;
    }

    protected void decodeCharactersGenericStructure() {
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(this.ec));
    }

    protected void decodeCharactersUndeclaredStructure() {
        this.currentRule.learnCharacters();
        this.replaceRuleAtTheTop(this.currentRule.getElementContentRule());
    }

    protected void decodeEndElementStructure() {
        this.popRule();
        this.popScope();
    }

    protected void decodeEndElementUndeclaredStructure() {
        this.currentRule.learnEndElement();
        this.decodeEndElementStructure();
    }

    protected void decodeEndDocumentStructure() throws EXIException {
        this.popRule();
    }

    protected void decodeDocTypeStructure() throws EXIException {
        try {
            this.docTypeName = this.block.readString();
            this.docTypePublicID = this.block.readString();
            this.docTypeSystemID = this.block.readString();
            this.docTypeText = this.block.readString();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeEntityReferenceStructure() throws EXIException {
        try {
            this.entityReferenceName = this.block.readString();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeCommentStructure() throws EXIException {
        try {
            this.comment = this.block.readString();
            this.replaceRuleAtTheTop(this.currentRule.getElementContentRule());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeProcessingInstructionStructure() throws EXIException {
        try {
            this.piTarget = this.block.readString();
            this.piData = this.block.readString();
            this.replaceRuleAtTheTop(this.currentRule.getElementContentRule());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public String getElementURI() {
        return this.elementURI;
    }

    public String getElementLocalName() {
        return this.elementLocalName;
    }

    public String getElementPrefix() {
        return this.elementPrefix;
    }

    public String getAttributeURI() {
        return this.attributeURI;
    }

    public String getAttributeLocalName() {
        return this.attributeLocalName;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public String getXsiTypeUri() {
        return this.xsiTypeUri;
    }

    public String getXsiTypeName() {
        return this.xsiTypeName;
    }

    public boolean getXsiNil() {
        return this.xsiNil;
    }

    public String getXsiNilDeviation() {
        return this.xsiNilDeviation;
    }

    public String getCharacters() {
        return this.characters;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public String getDocTypePublicID() {
        return this.docTypePublicID;
    }

    public String getDocTypeSystemID() {
        return this.docTypeSystemID;
    }

    public String getDocTypeText() {
        return this.docTypeText;
    }

    public String getEntityReferenceName() {
        return this.entityReferenceName;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNSUri() {
        return this.nsURI;
    }

    public String getNSPrefix() {
        return this.nsPrefix;
    }

    public String getPITarget() {
        return this.piTarget;
    }

    public String getPIData() {
        return this.piData;
    }
}

