/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXICoder;
import com.siemens.ct.exi.core.EXIHeader;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.grammar.GrammarSchemaInformed;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.DatatypeEvent;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.io.block.EncoderBlock;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.datatype.XSDBoolean;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EXIEncoderPrefixLess
extends AbstractEXICoder
implements EXIEncoder {
    protected EncoderBlock block;
    protected OutputStream os;
    protected XSDBoolean nil = XSDBoolean.newInstance();
    protected List<StringTableEncoder> scStringTables;
    protected List<Map<String, Map<String, Rule>>> scRuntimeDispatchers;

    public EXIEncoderPrefixLess(EXIFactory exiFactory) {
        super(exiFactory);
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            this.scStringTables = new ArrayList<StringTableEncoder>();
            this.scRuntimeDispatchers = new ArrayList<Map<String, Map<String, Rule>>>();
        }
    }

    protected void initForEachRun() throws EXIException {
        super.initForEachRun();
        this.block = this.exiFactory.createEncoderBlock(this.os);
        if (this.exiFactory.isFragment()) {
            this.pushRule(this.grammar.getBuiltInFragmentGrammar());
        } else {
            this.pushRule(this.grammar.getBuiltInDocumentGrammar());
        }
    }

    public void setOutput(OutputStream os, boolean exiBodyOnly) throws EXIException {
        this.os = os;
        if (!exiBodyOnly) {
            EXIHeader.write(os);
        }
    }

    protected void encode1stLevelEventCode(int pos) throws IOException {
        this.block.writeEventCode(pos, this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions));
    }

    protected void encode2ndLevelEventCode(int pos) throws IOException {
        this.block.writeEventCode(this.currentRule.getNumberOfEvents(), this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions));
        int ch2 = this.currentRule.get2ndLevelCharacteristics(this.fidelityOptions);
        assert (pos < ch2);
        this.block.writeEventCode(pos, MethodsBag.getCodingLength(ch2));
    }

    protected void encode3rdLevelEventCode(int pos) throws IOException {
        this.block.writeEventCode(this.currentRule.getNumberOfEvents(), this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions));
        int ch2 = this.currentRule.get2ndLevelCharacteristics(this.fidelityOptions);
        this.block.writeEventCode(ch2 - 1, MethodsBag.getCodingLength(ch2));
        int ch3 = this.currentRule.get3rdLevelCharacteristics(this.fidelityOptions);
        assert (pos < ch3);
        this.block.writeEventCode(pos, MethodsBag.getCodingLength(ch3));
    }

    protected void encodeQNamePrefix(String uri, String prefix) throws IOException {
    }

    protected void encodeQName(String uri, String localName, String prefix) throws IOException {
        this.block.writeUri(uri);
        this.block.writeLocalName(localName, uri);
        this.encodeQNamePrefix(uri, prefix);
    }

    public void encodeStartDocument() throws EXIException {
        if (this.os == null) {
            throw new EXIException("No valid EXI OutputStream set for encoding. Please use setOutput( ... )");
        }
        this.initForEachRun();
        this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(0));
    }

    public void encodeEndDocument() throws EXIException {
        try {
            int ec = this.currentRule.get1stLevelEventCode(this.eventED);
            if (ec == -1) {
                throw new EXIException("No EXI Event found for endDocument");
            }
            this.encode1stLevelEventCode(ec);
            this.block.flush();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException {
        try {
            this.eventSE.setNamespaceURI(uri);
            this.eventSE.setLocalPart(localName);
            int ec = this.currentRule.get1stLevelEventCode(this.eventSE);
            if (ec == -1) {
                int ecGeneric = this.currentRule.get1stLevelEventCode(this.eventSEg);
                if (ecGeneric == -1) {
                    int ecSEundeclared = this.currentRule.get2ndLevelEventCode(EventType.START_ELEMENT_GENERIC_UNDECLARED, this.fidelityOptions);
                    if (ecSEundeclared == -1) {
                        throw new IllegalArgumentException("SE " + uri + ":" + localName);
                    }
                    this.encode2ndLevelEventCode(ecSEundeclared);
                    this.encodeQName(uri, localName, prefix);
                    this.currentRule.learnStartElement(uri, localName);
                    this.replaceRuleAtTheTop(this.currentRule.getElementContentRuleForUndeclaredSE());
                    this.pushRule(uri, localName);
                } else {
                    this.encode1stLevelEventCode(ecGeneric);
                    this.encodeQName(uri, localName, prefix);
                    Rule tmpStorage = this.currentRule;
                    this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ecGeneric));
                    this.pushRule(uri, localName);
                    tmpStorage.learnStartElement(uri, localName);
                }
            } else {
                this.encode1stLevelEventCode(ec);
                this.encodeQNamePrefix(uri, prefix);
                this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ec));
                this.pushRule(uri, localName);
            }
            this.pushScope(uri, localName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException {
        this.namespaces.declarePrefix(prefix, uri);
    }

    public void encodeEndElement() throws EXIException {
        try {
            int ecCH;
            int ec = this.currentRule.get1stLevelEventCode(this.eventEE);
            if (ec == -1 && (ecCH = this.currentRule.get1stLevelEventCode(this.eventCH)) != -1 && this.block.isTypeValid(this.getDatatypeOfEvent(ecCH), "")) {
                this.encode1stLevelEventCode(ecCH);
                this.block.writeTypeValidValue(this.getScopeURI(), this.getScopeLocalName());
                this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ecCH));
                ec = this.currentRule.get1stLevelEventCode(this.eventEE);
            }
            if (ec == -1) {
                int ecEEundeclared = this.currentRule.get2ndLevelEventCode(EventType.END_ELEMENT_UNDECLARED, this.fidelityOptions);
                if (ecEEundeclared == -1) {
                    throw new IllegalArgumentException("EE " + this.getScopeURI() + ":" + this.getScopeLocalName());
                }
                this.encode2ndLevelEventCode(ecEEundeclared);
                this.currentRule.learnEndElement();
            } else {
                this.encode1stLevelEventCode(ec);
            }
            this.popRule();
            this.popScope();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void encodeXsiType(String raw) throws EXIException {
        try {
            if (this.currentRule.isSchemaRule()) {
                int ec2 = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_TYPE, this.fidelityOptions);
                if (ec2 == -1) {
                    assert (this.fidelityOptions.isStrict());
                    String msg = "Skip unexpected type-cast, xsi:type=" + raw;
                    this.errorHandler.warning(new EXIException(msg));
                } else {
                    String xsiTypeLocalName;
                    String xsiTypePrefix = QNameUtilities.getPrefixPart(raw);
                    String xsiTypeURI = this.namespaces.getURI(xsiTypePrefix);
                    if (xsiTypeURI == null) {
                        xsiTypeURI = "";
                        xsiTypeLocalName = raw;
                    } else {
                        xsiTypeLocalName = QNameUtilities.getLocalPart(raw);
                    }
                    TypeGrammar tg = ((GrammarSchemaInformed)this.grammar).getTypeGrammar(xsiTypeURI, xsiTypeLocalName);
                    if (tg == null) {
                        this.encode2ndLevelEventCode(ec2);
                        this.encodeQName("", raw, "");
                    } else {
                        this.encode2ndLevelEventCode(ec2);
                        this.encodeQName(xsiTypeURI, xsiTypeLocalName, "");
                        this.replaceRuleAtTheTop(tg.getType());
                        this.pushScopeType(xsiTypeURI, xsiTypeLocalName);
                    }
                }
            } else {
                int ecATundeclared = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
                if (ecATundeclared == -1) {
                    String msg = "Skip AT xsi:type: " + raw;
                    this.errorHandler.warning(new EXIException(msg));
                } else {
                    this.encode2ndLevelEventCode(ecATundeclared);
                    this.encodeQName("http://www.w3.org/2001/XMLSchema-instance", "type", "");
                    this.block.writeValueAsString("http://www.w3.org/2001/XMLSchema-instance", "type", raw);
                }
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void encodeXsiNil(String rawNil) throws EXIException {
        block11: {
            try {
                if (this.currentRule.isSchemaRule()) {
                    int ec2 = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_NIL, this.fidelityOptions);
                    if (ec2 == -1) {
                        String msg = "Skip AT xsi:nil=" + rawNil;
                        this.errorHandler.warning(new EXIException(msg));
                        break block11;
                    }
                    try {
                        this.nil.parse(rawNil);
                        this.encode2ndLevelEventCode(ec2);
                        try {
                            this.block.writeBoolean(this.nil.getBoolean());
                        }
                        catch (IOException e) {
                            throw new EXIException(e);
                        }
                        if (this.nil.getBoolean()) {
                            this.replaceRuleAtTheTop(((SchemaInformedRule)this.currentRule).getTypeEmpty());
                        }
                        break block11;
                    }
                    catch (XMLParsingException e) {
                        int ec2ATdeviated = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_INVALID_VALUE, this.fidelityOptions);
                        this.encode2ndLevelEventCode(ec2ATdeviated);
                        SchemaInformedRule schemaCurrentRule = (SchemaInformedRule)this.currentRule;
                        int ec3nil = schemaCurrentRule.getNumberOfSchemaDeviatedAttributes() - 1;
                        this.block.writeEventCode(ec3nil, MethodsBag.getCodingLength(schemaCurrentRule.getNumberOfSchemaDeviatedAttributes()));
                        this.block.writeString(rawNil);
                    }
                    break block11;
                }
                int ecATundeclared = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
                if (ecATundeclared == -1) {
                    String msg = "Skip AT xsi:nil";
                    this.errorHandler.warning(new EXIException(msg));
                } else {
                    this.encode2ndLevelEventCode(ecATundeclared);
                    this.encodeQName("http://www.w3.org/2001/XMLSchema-instance", "nil", "");
                    this.block.writeValueAsString("http://www.w3.org/2001/XMLSchema-instance", "nil", rawNil);
                }
            }
            catch (IOException e) {
                throw new EXIException(e);
            }
        }
    }

    public void encodeAttribute(String uri, String localName, String prefix, String value) throws EXIException {
        try {
            this.eventAT.setNamespaceURI(uri);
            this.eventAT.setLocalPart(localName);
            int ec = this.currentRule.get1stLevelEventCode(this.eventAT);
            if (ec == -1) {
                int ecGeneric = this.currentRule.get1stLevelEventCode(this.eventATg);
                if (ecGeneric == -1) {
                    int ecATundeclared = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
                    if (ecATundeclared == -1) {
                        assert (this.fidelityOptions.isStrict());
                        String msg = "Skip AT " + uri + ":" + localName + " = " + value + " (StrictMode=" + this.fidelityOptions.isStrict() + ")";
                        this.errorHandler.warning(new EXIException(msg));
                    } else {
                        this.encode2ndLevelEventCode(ecATundeclared);
                        this.encodeQName(uri, localName, prefix);
                        this.block.writeValueAsString(uri, localName, value);
                        this.currentRule.learnAttribute(uri, localName);
                    }
                } else {
                    this.encode1stLevelEventCode(ecGeneric);
                    this.encodeQName(uri, localName, prefix);
                    this.block.writeValueAsString(uri, localName, value);
                    this.currentRule.learnAttribute(uri, localName);
                    this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ecGeneric));
                }
            } else {
                if (this.block.isTypeValid(this.getDatatypeOfEvent(ec), value)) {
                    this.encode1stLevelEventCode(ec);
                    this.encodeQNamePrefix(uri, prefix);
                    this.block.writeTypeValidValue(uri, localName);
                } else {
                    int ec2ATdeviated = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_INVALID_VALUE, this.fidelityOptions);
                    this.encode2ndLevelEventCode(ec2ATdeviated);
                    SchemaInformedRule schemaCurrentRule = (SchemaInformedRule)this.currentRule;
                    int ec3 = ec - schemaCurrentRule.getLeastAttributeEventCode();
                    this.block.writeEventCode(ec3, MethodsBag.getCodingLength(schemaCurrentRule.getNumberOfSchemaDeviatedAttributes()));
                    this.encodeQNamePrefix(uri, prefix);
                    this.block.writeValueAsString(uri, localName, value);
                }
                this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ec));
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void encodeCharacters(String chars) throws EXIException {
        try {
            int ec = this.currentRule.get1stLevelEventCode(this.eventCH);
            if (ec == -1 || !this.block.isTypeValid(this.getDatatypeOfEvent(ec), chars)) {
                int ecGeneric = this.currentRule.get1stLevelEventCode(this.eventCHg);
                if (ecGeneric == -1) {
                    int ecCHundeclared = this.currentRule.get2ndLevelEventCode(EventType.CHARACTERS_GENERIC_UNDECLARED, this.fidelityOptions);
                    if (ecCHundeclared == -1) {
                        String msg = "Skip CH: '" + chars + "'";
                        this.errorHandler.warning(new EXIException(msg));
                    } else {
                        this.encode2ndLevelEventCode(ecCHundeclared);
                        this.currentRule.learnCharacters();
                        this.block.writeValueAsString(this.getScopeURI(), this.getScopeLocalName(), chars);
                        this.replaceRuleAtTheTop(this.currentRule.getElementContentRule());
                    }
                } else {
                    this.encode1stLevelEventCode(ecGeneric);
                    this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ecGeneric));
                    this.block.writeValueAsString(this.getScopeURI(), this.getScopeLocalName(), chars);
                }
            } else {
                this.encode1stLevelEventCode(ec);
                this.block.writeTypeValidValue(this.getScopeURI(), this.getScopeLocalName());
                this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(ec));
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected Datatype getDatatypeOfEvent(int eventCode) {
        assert (this.currentRule.get1stLevelEvent(eventCode) instanceof DatatypeEvent);
        return ((DatatypeEvent)this.currentRule.get1stLevelEvent(eventCode)).getDatatype();
    }

    public void encodeDocType(String name, String publicID, String systemID, String text) throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            try {
                int ec2 = this.currentRule.get2ndLevelEventCode(EventType.DOC_TYPE, this.fidelityOptions);
                this.encode2ndLevelEventCode(ec2);
                this.block.writeString(name);
                this.block.writeString(publicID);
                this.block.writeString(systemID);
                this.block.writeString(text);
            }
            catch (IOException e) {
                throw new EXIException(e);
            }
        }
    }

    public void encodeEntityReference(String name) throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            try {
                int ec2 = this.currentRule.get2ndLevelEventCode(EventType.ENTITY_REFERENCE, this.fidelityOptions);
                this.encode2ndLevelEventCode(ec2);
                this.block.writeString(name);
            }
            catch (IOException e) {
                throw new EXIException(e);
            }
        }
    }

    public void encodeComment(char[] ch, int start, int length) throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
            try {
                int ec3 = this.currentRule.get3rdLevelEventCode(EventType.COMMENT, this.fidelityOptions);
                this.encode3rdLevelEventCode(ec3);
                this.block.writeString(new String(ch, start, length));
                this.replaceRuleAtTheTop(this.currentRule.getElementContentRule());
            }
            catch (IOException e) {
                throw new EXIException(e);
            }
        }
    }

    public void encodeProcessingInstruction(String target, String data) throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PIS")) {
            try {
                int ec3 = this.currentRule.get3rdLevelEventCode(EventType.PROCESSING_INSTRUCTION, this.fidelityOptions);
                this.encode3rdLevelEventCode(ec3);
                this.block.writeString(target);
                this.block.writeString(data);
                this.replaceRuleAtTheTop(this.currentRule.getElementContentRule());
            }
            catch (IOException e) {
                throw new EXIException(e);
            }
        }
    }

    public int encodeStartFragmentSelfContained(String uri, String localName, String prefix) throws EXIException {
        try {
            int skipBytesSC = -1;
            int ec2 = this.currentRule.get2ndLevelEventCode(EventType.SELF_CONTAINED, this.fidelityOptions);
            if (ec2 == -1) {
                throw new EXIException("SelfContained fragments need to be supported by EXI's Options. Please revise your configuration.");
            }
            this.encode2ndLevelEventCode(ec2);
            this.block.skipToNextByteBoundary();
            if (this.block.bytePositionSupported()) {
                skipBytesSC = this.block.getBytePosition();
            }
            TypeEncoder te = this.block.getTypeEncoder();
            this.scStringTables.add(te.getStringTable());
            te.setStringTable(this.exiFactory.createTypeEncoder().getStringTable());
            this.scRuntimeDispatchers.add(this.runtimeDispatcher);
            this.runtimeDispatcher = new HashMap();
            this.replaceRuleAtTheTop(this.grammar.getBuiltInFragmentGrammar());
            this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(0));
            this.encodeStartElement(uri, localName, prefix);
            return skipBytesSC;
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void encodeEndFragmentSelfContained() throws EXIException {
        try {
            int ec = this.currentRule.get1stLevelEventCode(this.eventED);
            if (ec == -1) {
                throw new EXIException("No EXI Event found for endDocument");
            }
            this.encode1stLevelEventCode(ec);
            this.popRule();
            TypeEncoder te = this.block.getTypeEncoder();
            te.setStringTable(this.scStringTables.remove(this.scStringTables.size() - 1));
            this.runtimeDispatcher = this.scRuntimeDispatchers.remove(this.scRuntimeDispatchers.size() - 1);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }
}

