/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.sax;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.sax.SAXEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXEncoderExtendedHandler
extends SAXEncoder {
    protected boolean preserveDTD;
    protected String docTypeName;
    protected String docTypePublicID;
    protected String docTypeSystemID;
    protected String docTypeText;
    protected boolean noEntityReference;

    public SAXEncoderExtendedHandler(EXIFactory factory) {
        super(factory);
        this.preserveDTD = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_DTDS");
    }

    public void startDocument() throws SAXException {
        this.noEntityReference = true;
        super.startDocument();
    }

    public void startElement(String uri, String local, String raw, Attributes attributes) throws SAXException {
        try {
            this.startElementPfx(uri, local, QNameUtilities.getPrefixPart(raw), attributes);
        }
        catch (EXIException e) {
            throw new SAXException("startElement: " + raw, e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.noEntityReference) {
            super.characters(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
            this.encoder.encodeComment(ch, start, length);
        }
        catch (EXIException e) {
            throw new SAXException("comment", e);
        }
    }

    public void startCDATA() throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
        }
        catch (EXIException e) {
            throw new SAXException("startCDATA", e);
        }
    }

    public void endCDATA() throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
        }
        catch (EXIException e) {
            throw new SAXException("endCDATA", e);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
            this.docTypeName = name;
            this.docTypePublicID = publicId == null ? "" : publicId;
            this.docTypeSystemID = systemId == null ? "" : systemId;
            this.docTypeText = "";
        }
        catch (EXIException e) {
            throw new SAXException("startDTD", e);
        }
    }

    public void endDTD() throws SAXException {
        try {
            this.encoder.encodeDocType(this.docTypeName, this.docTypePublicID, this.docTypeSystemID, this.docTypeText);
        }
        catch (Exception e) {
            throw new SAXException("endDTD", e);
        }
    }

    public void startEntity(String name) throws SAXException {
        try {
            if (this.preserveDTD) {
                this.charEncoder.checkPendingChars();
                this.noEntityReference = false;
            }
        }
        catch (EXIException e) {
            throw new SAXException("startEntity", e);
        }
    }

    public void endEntity(String name) throws SAXException {
        try {
            if (!this.noEntityReference) {
                if (!name.equals("[dtd]")) {
                    this.encoder.encodeEntityReference(name);
                }
                this.noEntityReference = true;
            }
        }
        catch (EXIException e) {
            throw new SAXException("endEntity " + name, e);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void elementDecl(String name, String model) throws SAXException {
        this.docTypeText = String.valueOf(this.docTypeText) + "<!ELEMENT " + name + " " + model + "> ";
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        this.docTypeText = String.valueOf(this.docTypeText) + "<!ATTLIST " + eName + " " + aName + " " + type + " " + mode + "> ";
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        this.docTypeText = String.valueOf(this.docTypeText) + "<!ENTITY " + name + " \"" + value + "\"> ";
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }
}

