/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.datatype.AbstractTypeCoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoderImpl;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoderImplNoGlobalValues;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;

public abstract class AbstractTypeEncoder
extends AbstractTypeCoder
implements TypeEncoder {
    protected StringTableEncoder stringTable;

    public StringTableEncoder getStringTable() {
        return this.stringTable;
    }

    public void setStringTable(StringTableEncoder stringTable) {
        this.stringTable = stringTable;
    }

    public AbstractTypeEncoder(EXIFactory exiFactory) {
        this.stringTable = exiFactory.getCodingMode().usesRechanneling() ? new StringTableEncoderImplNoGlobalValues(exiFactory.getGrammar().isSchemaInformed()) : new StringTableEncoderImpl(exiFactory.getGrammar().isSchemaInformed());
    }

    public void writeValueAsString(EncoderChannel valueChannel, String uri, String localName, String value) throws IOException {
        if (!this.writeStringAsLocalHit(valueChannel, uri, localName, value) && !this.writeStringAsGlobalHit(valueChannel, value)) {
            this.writeStringAsMiss(valueChannel, uri, localName, value);
        }
    }

    public boolean writeStringAsLocalHit(EncoderChannel valueChannel, String uri, String localName, String value) throws IOException {
        int localID = this.stringTable.getLocalValueID(uri, localName, value);
        if (localID == -1) {
            return false;
        }
        valueChannel.encodeUnsignedInteger(0);
        int n = MethodsBag.getCodingLength(this.stringTable.getLocalValueTableSize(uri, localName));
        valueChannel.encodeNBitUnsignedInteger(localID, n);
        return true;
    }

    public boolean writeStringAsGlobalHit(EncoderChannel valueChannel, String value) throws IOException {
        int globalID = this.stringTable.getGlobalValueID(value);
        if (globalID == -1) {
            return false;
        }
        valueChannel.encodeUnsignedInteger(1);
        valueChannel.encodeNBitUnsignedInteger(globalID, MethodsBag.getCodingLength(this.stringTable.getGlobalValueTableSize()));
        return true;
    }

    public void writeStringAsMiss(EncoderChannel valueChannel, String uri, String localName, String value) throws IOException {
        valueChannel.encodeUnsignedInteger(value.length() + 2);
        valueChannel.encodeStringOnly(value);
        this.stringTable.addLocalValue(uri, localName, value);
        this.stringTable.addGlobalValue(value);
    }

    public void finish() throws IOException {
    }
}

