/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.stringtable;

import com.siemens.ct.exi.datatype.stringtable.AbstractStringTable;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTablePartitionEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTablePartitionEncoderImpl;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTableEncoderImpl
extends AbstractStringTable
implements StringTableEncoder {
    protected StringTablePartitionEncoder uriPartition = this.getNewPartition();
    protected Map<String, StringTablePartitionEncoder> prefixPartitions = new HashMap<String, StringTablePartitionEncoder>();
    protected Map<String, StringTablePartitionEncoder> localNamePartitions = new HashMap<String, StringTablePartitionEncoder>();
    protected Map<String, HashMap<String, StringTablePartitionEncoder>> localValuePartitions = new HashMap<String, HashMap<String, StringTablePartitionEncoder>>();
    protected StringTablePartitionEncoder globalValuePartition = this.getNewPartition();

    public StringTableEncoderImpl(boolean isSchemaInformed) {
        this.initURI(this.uriPartition, isSchemaInformed);
        this.prefixPartitions.put("", this.getNewPartition());
        this.prefixPartitions.put("http://www.w3.org/XML/1998/namespace", this.getNewPartition());
        this.prefixPartitions.put("http://www.w3.org/2001/XMLSchema-instance", this.getNewPartition());
        this.initPrefixEmpty(this.prefixPartitions.get(""));
        this.initPrefixXML(this.prefixPartitions.get("http://www.w3.org/XML/1998/namespace"));
        this.initPrefixXSI(this.prefixPartitions.get("http://www.w3.org/2001/XMLSchema-instance"));
        this.localNamePartitions.put("http://www.w3.org/XML/1998/namespace", this.getNewPartition());
        this.localNamePartitions.put("http://www.w3.org/2001/XMLSchema-instance", this.getNewPartition());
        this.localNamePartitions.put("http://www.w3.org/2001/XMLSchema", this.getNewPartition());
        this.initLocalNameXML(this.localNamePartitions.get("http://www.w3.org/XML/1998/namespace"));
        this.initLocalNameXSI(this.localNamePartitions.get("http://www.w3.org/2001/XMLSchema-instance"));
        this.initLocalNameXSD(this.localNamePartitions.get("http://www.w3.org/2001/XMLSchema"));
    }

    protected StringTablePartitionEncoder getNewPartition() {
        return new StringTablePartitionEncoderImpl();
    }

    protected int getID(StringTablePartitionEncoder partition, String key) {
        return partition == null ? -1 : partition.getIndex(key);
    }

    protected StringTablePartitionEncoder getPartition(Map<String, StringTablePartitionEncoder> partitions, String key) {
        StringTablePartitionEncoder partition = partitions.get(key);
        if (partition == null) {
            partition = this.getNewPartition();
            partitions.put(key, partition);
        }
        return partition;
    }

    @Override
    public int getURIID(String uri) {
        return this.uriPartition.getIndex(uri);
    }

    @Override
    public int getPrefixID(String uri, String prefix) {
        return this.getID(this.prefixPartitions.get(uri), prefix);
    }

    @Override
    public int getLocalNameID(String uri, String name) {
        return this.getID(this.localNamePartitions.get(uri), name);
    }

    @Override
    public int getLocalValueID(String uri, String localName, String value) {
        HashMap<String, StringTablePartitionEncoder> uriSection = this.localValuePartitions.get(uri);
        return uriSection == null ? -1 : this.getID(uriSection.get(localName), value);
    }

    @Override
    public int getGlobalValueID(String value) {
        return this.globalValuePartition.getIndex(value);
    }

    @Override
    public void addURI(String uri) {
        this.uriPartition.add(uri);
    }

    @Override
    public int getURITableSize() {
        return this.uriPartition.getSize();
    }

    @Override
    public void addPrefix(String uri, String prefix) {
        this.getPartition(this.prefixPartitions, uri).add(prefix);
    }

    @Override
    public int getPrefixTableSize(String uri) {
        return this.getPartition(this.prefixPartitions, uri).getSize();
    }

    @Override
    public void addLocalName(String uri, String name) {
        this.getPartition(this.localNamePartitions, uri).add(name);
    }

    @Override
    public int getLocalNameTableSize(String uri) {
        return this.getPartition(this.localNamePartitions, uri).getSize();
    }

    @Override
    public void addLocalValue(String uri, String localName, String value) {
        HashMap<String, StringTablePartitionEncoder> uriSection = this.localValuePartitions.get(uri);
        if (uriSection == null) {
            uriSection = new HashMap();
            this.localValuePartitions.put(uri, uriSection);
        }
        this.getPartition(uriSection, localName).add(value);
    }

    @Override
    public int getLocalValueTableSize(String uri, String localName) {
        HashMap<String, StringTablePartitionEncoder> uriSection = this.localValuePartitions.get(uri);
        return uriSection == null ? 0 : this.getPartition(uriSection, localName).getSize();
    }

    @Override
    public void addGlobalValue(String value) {
        this.globalValuePartition.add(value);
    }

    @Override
    public int getGlobalValueTableSize() {
        return this.globalValuePartition.getSize();
    }
}

