/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.helpers;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIDecoder;
import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.GrammarFactory;
import com.siemens.ct.exi.api.sax.EXIWriter;
import com.siemens.ct.exi.core.EXIDecoderInOrder;
import com.siemens.ct.exi.core.EXIDecoderReordered;
import com.siemens.ct.exi.core.EXIEncoderPrefixAware;
import com.siemens.ct.exi.core.EXIEncoderPrefixLess;
import com.siemens.ct.exi.core.sax.SAXDecoder;
import com.siemens.ct.exi.core.sax.SAXDecoderExtendedHandler;
import com.siemens.ct.exi.core.sax.SAXEncoder;
import com.siemens.ct.exi.core.sax.SAXEncoderExtendedHandler;
import com.siemens.ct.exi.datatype.DatatypeRepresentation;
import com.siemens.ct.exi.datatype.decoder.AbstractTypeDecoder;
import com.siemens.ct.exi.datatype.decoder.TypeDecoder;
import com.siemens.ct.exi.datatype.decoder.TypeDecoderDatatypeRepresentationMap;
import com.siemens.ct.exi.datatype.decoder.TypeDecoderLexical;
import com.siemens.ct.exi.datatype.decoder.TypeDecoderString;
import com.siemens.ct.exi.datatype.decoder.TypeDecoderTyped;
import com.siemens.ct.exi.datatype.encoder.AbstractTypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoderDatatypeRespresentationMap;
import com.siemens.ct.exi.datatype.encoder.TypeEncoderLexical;
import com.siemens.ct.exi.datatype.encoder.TypeEncoderString;
import com.siemens.ct.exi.datatype.encoder.TypeEncoderTyped;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.io.block.AbstractDecoderBlock;
import com.siemens.ct.exi.io.block.AbstractEncoderBlock;
import com.siemens.ct.exi.io.block.DecoderBitBlock;
import com.siemens.ct.exi.io.block.DecoderBlock;
import com.siemens.ct.exi.io.block.DecoderByteBlock;
import com.siemens.ct.exi.io.block.DecoderByteBlockCompression;
import com.siemens.ct.exi.io.block.DecoderByteBlockPreCompression;
import com.siemens.ct.exi.io.block.EncoderBitBlock;
import com.siemens.ct.exi.io.block.EncoderBlock;
import com.siemens.ct.exi.io.block.EncoderByteBlock;
import com.siemens.ct.exi.io.block.EncoderByteBlockCompression;
import com.siemens.ct.exi.io.block.EncoderByteBlockPreCompression;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xml.sax.XMLReader;

public class DefaultEXIFactory
implements EXIFactory {
    protected Grammar grammar;
    protected boolean isFragment;
    protected CodingMode codingMode;
    protected FidelityOptions fidelityOptions;
    protected DatatypeRepresentation[] userDefinedDatatypeRepresentations;
    protected boolean exiBodyOnly = false;

    protected DefaultEXIFactory() {
    }

    protected static void setDefaultValues(EXIFactory factory) {
        factory.setFidelityOptions(FidelityOptions.createDefault());
        factory.setCodingMode(CodingMode.BIT_PACKED);
        factory.setFragment(false);
        factory.setGrammar(GrammarFactory.newInstance().createSchemaLessGrammar());
    }

    public static EXIFactory newInstance() {
        DefaultEXIFactory factory = new DefaultEXIFactory();
        DefaultEXIFactory.setDefaultValues(factory);
        return factory;
    }

    public void setFidelityOptions(FidelityOptions fidelityOptions) {
        this.fidelityOptions = fidelityOptions;
    }

    public FidelityOptions getFidelityOptions() {
        return this.fidelityOptions;
    }

    public void setDatatypeRepresentationMap(DatatypeRepresentation[] datatypeRepresentations) {
        this.userDefinedDatatypeRepresentations = datatypeRepresentations;
    }

    public void setGrammar(Grammar grammar) {
        assert (grammar != null);
        this.grammar = grammar;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    protected boolean isSchemaInformed() {
        return this.grammar.isSchemaInformed();
    }

    public void setFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setCodingMode(CodingMode codingMode) {
        this.codingMode = codingMode;
    }

    public CodingMode getCodingMode() {
        return this.codingMode;
    }

    public void setEXIBodyOnly(boolean exiBodyOnly) {
        this.exiBodyOnly = exiBodyOnly;
    }

    public boolean isEXIBodyOnly() {
        return this.exiBodyOnly;
    }

    public EXIEncoder createEXIEncoder() {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES")) {
            return new EXIEncoderPrefixAware(this);
        }
        return new EXIEncoderPrefixLess(this);
    }

    public EXIWriter createEXIWriter() {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXEncoderExtendedHandler(this);
        }
        return new SAXEncoder(this);
    }

    public EXIDecoder createEXIDecoder() {
        if (this.codingMode.usesRechanneling()) {
            return new EXIDecoderReordered(this);
        }
        return new EXIDecoderInOrder(this);
    }

    public XMLReader createEXIReader() {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXDecoderExtendedHandler(this);
        }
        return new SAXDecoder(this);
    }

    public TypeEncoder createTypeEncoder() {
        AbstractTypeEncoder typeEncoder;
        if (this.isSchemaInformed()) {
            if (this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES")) {
                typeEncoder = new TypeEncoderLexical(this);
            } else if (this.userDefinedDatatypeRepresentations != null && this.userDefinedDatatypeRepresentations.length > 0) {
                TypeEncoderDatatypeRespresentationMap enc = new TypeEncoderDatatypeRespresentationMap(this);
                int i = 0;
                while (i < this.userDefinedDatatypeRepresentations.length) {
                    enc.registerDatatypeRepresentation(this.userDefinedDatatypeRepresentations[i]);
                    ++i;
                }
                typeEncoder = enc;
            } else {
                typeEncoder = new TypeEncoderTyped(this);
            }
        } else {
            typeEncoder = new TypeEncoderString(this);
        }
        this.getGrammar().populateStringTable(typeEncoder.getStringTable());
        return typeEncoder;
    }

    public TypeDecoder createTypeDecoder() {
        AbstractTypeDecoder typeDecoder;
        if (this.isSchemaInformed()) {
            if (this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES")) {
                typeDecoder = new TypeDecoderLexical(this);
            } else if (this.userDefinedDatatypeRepresentations != null && this.userDefinedDatatypeRepresentations.length > 0) {
                TypeDecoderDatatypeRepresentationMap dec = new TypeDecoderDatatypeRepresentationMap(this);
                int i = 0;
                while (i < this.userDefinedDatatypeRepresentations.length) {
                    dec.registerDatatypeRepresentation(this.userDefinedDatatypeRepresentations[i]);
                    ++i;
                }
                typeDecoder = dec;
            } else {
                typeDecoder = new TypeDecoderTyped(this);
            }
        } else {
            typeDecoder = new TypeDecoderString(this);
        }
        this.getGrammar().populateStringTable(typeDecoder.getStringTable());
        return typeDecoder;
    }

    public EncoderBlock createEncoderBlock(OutputStream outputStream) {
        AbstractEncoderBlock encBlock;
        TypeEncoder typeEncoder = this.createTypeEncoder();
        switch (this.codingMode) {
            case BIT_PACKED: {
                encBlock = new EncoderBitBlock(outputStream, typeEncoder);
                break;
            }
            case BYTE_PACKED: {
                encBlock = new EncoderByteBlock(outputStream, typeEncoder);
                break;
            }
            case PRE_COMPRESSION: {
                encBlock = new EncoderByteBlockPreCompression(outputStream, typeEncoder);
                break;
            }
            case COMPRESSION: {
                encBlock = new EncoderByteBlockCompression(outputStream, typeEncoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CodingMode!");
            }
        }
        return encBlock;
    }

    public DecoderBlock createDecoderBlock(InputStream inputStream) throws IOException {
        AbstractDecoderBlock decBlock;
        TypeDecoder typeDecoder = this.createTypeDecoder();
        switch (this.codingMode) {
            case BIT_PACKED: {
                decBlock = new DecoderBitBlock(inputStream, typeDecoder);
                break;
            }
            case BYTE_PACKED: {
                decBlock = new DecoderByteBlock(inputStream, typeDecoder);
                break;
            }
            case PRE_COMPRESSION: {
                decBlock = new DecoderByteBlockPreCompression(inputStream, typeDecoder);
                break;
            }
            case COMPRESSION: {
                decBlock = new DecoderByteBlockCompression(inputStream, typeDecoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CodingMode!");
            }
        }
        return decBlock;
    }
}

