/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import com.siemens.ct.exi.util.datatype.XSDBase64;
import com.siemens.ct.exi.util.datatype.XSDDatetime;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class AbstractDecoderChannel
implements DecoderChannel {
    static final int FLOAT_SPECIAL_VALUES = -16384;
    final StringBuilder sb = new StringBuilder();

    public String decodeBinaryAsString() throws IOException {
        byte[] b = this.decodeBinary();
        return new String(XSDBase64.encode(b));
    }

    public String decodeBooleanAsString() throws IOException {
        return this.decodeBoolean() ? "true" : "false";
    }

    public String decodeString() throws IOException {
        int length = this.decodeUnsignedInteger();
        this.sb.setLength(0);
        int i = 0;
        while (i < length) {
            int ch = this.decodeUnsignedInteger();
            if (Character.isSupplementaryCodePoint(ch)) {
                this.sb.append(Character.toChars(ch));
            } else {
                this.sb.append((char)ch);
            }
            ++i;
        }
        return this.sb.toString();
    }

    public String decodeStringOnly(int length) throws IOException {
        this.sb.setLength(0);
        int i = 0;
        while (i < length) {
            int ch = this.decodeUnsignedInteger();
            if (Character.isSupplementaryCodePoint(ch)) {
                this.sb.append(Character.toChars(ch));
            } else {
                this.sb.append((char)ch);
            }
            ++i;
        }
        return this.sb.toString();
    }

    public int decodeInteger() throws IOException {
        if (this.decodeBoolean()) {
            return (this.decodeUnsignedInteger() + 1) * -1;
        }
        return this.decodeUnsignedInteger();
    }

    public long decodeIntegerAsLong() throws IOException {
        if (this.decodeBoolean()) {
            return (this.decodeUnsignedIntegerAsLong() + 1L) * -1L;
        }
        return this.decodeUnsignedIntegerAsLong();
    }

    public BigInteger decodeIntegerAsBigInteger() throws IOException {
        if (this.decodeBoolean()) {
            return this.decodeUnsignedIntegerAsBigInteger().add(BigInteger.ONE).negate();
        }
        return this.decodeUnsignedIntegerAsBigInteger();
    }

    public String decodeIntegerAsString() throws IOException {
        if (this.decodeBoolean()) {
            this.sb.setLength(0);
            this.sb.append('-');
            this.sb.append(this.decodeUnsignedIntegerAsBigInteger().add(BigInteger.ONE).toString());
            return this.sb.toString();
        }
        return this.decodeUnsignedIntegerAsString();
    }

    public int decodeUnsignedInteger() throws IOException {
        int b;
        int result = 0;
        int multiplier = 1;
        do {
            b = this.decode();
            result += multiplier * (b & 0x7F);
            multiplier <<= 7;
        } while (b >>> 7 == 1);
        return result;
    }

    public long decodeUnsignedIntegerAsLong() throws IOException {
        int b;
        long result = 0L;
        long multiplier = 1L;
        do {
            b = this.decode();
            result += multiplier * (long)(b & 0x7F);
            multiplier <<= 7;
        } while (b >>> 7 == 1);
        return result;
    }

    public BigInteger decodeUnsignedIntegerAsBigInteger() throws IOException {
        int b;
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        do {
            b = this.decode();
            result = result.add(multiplier.multiply(BigInteger.valueOf(b & 0x7F)));
            multiplier = multiplier.shiftLeft(7);
        } while (b >>> 7 == 1);
        return result;
    }

    public String decodeUnsignedIntegerAsString() throws IOException {
        return this.decodeUnsignedIntegerAsBigInteger().toString();
    }

    public String decodeNBitUnsignedIntegerAsString(int n) throws IOException {
        this.sb.setLength(0);
        this.sb.append(this.decodeNBitUnsignedInteger(n));
        return this.sb.toString();
    }

    public BigDecimal decodeDecimal() throws IOException {
        boolean negative = this.decodeBoolean();
        BigInteger integral = this.decodeUnsignedIntegerAsBigInteger();
        String sFractional = new StringBuilder(this.decodeUnsignedIntegerAsBigInteger().toString()).reverse().toString();
        return new BigDecimal(negative ? "-" + integral + "." + sFractional : integral + "." + sFractional);
    }

    public String decodeDecimalAsString() throws IOException {
        boolean negative = this.decodeBoolean();
        String integral = this.decodeUnsignedIntegerAsString();
        String sFractional = new StringBuilder(this.decodeUnsignedIntegerAsString()).reverse().toString();
        this.sb.setLength(0);
        if (negative) {
            this.sb.append('-');
        }
        this.sb.append(integral);
        this.sb.append('.');
        this.sb.append(sFractional);
        return this.sb.toString();
    }

    public float decodeFloat() throws IOException {
        int iMantissa = this.decodeInteger();
        int iExponent = this.decodeInteger();
        if (iExponent == -16384) {
            if (iMantissa == -1) {
                return Float.NEGATIVE_INFINITY;
            }
            if (iMantissa == 1) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NaN;
        }
        return Float.parseFloat(String.valueOf(iMantissa) + "E" + iExponent);
    }

    public String decodeFloatAsString() throws IOException {
        long iMantissa = this.decodeIntegerAsLong();
        long iExponent = this.decodeIntegerAsLong();
        if (iExponent == -16384L) {
            if (iMantissa == -1L) {
                return "-INF";
            }
            if (iMantissa == 1L) {
                return "INF";
            }
            return "NaN";
        }
        this.sb.setLength(0);
        this.sb.append(iMantissa);
        this.sb.append('E');
        this.sb.append(iExponent);
        return this.sb.toString();
    }

    public Calendar decodeDateTime(DatetimeType type) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        switch (type) {
            case gYear: {
                cal.set(1, this.decodeInteger() + 2000);
                this.decodeDateTimeTimezone(cal);
                break;
            }
            case gYearMonth: 
            case date: {
                cal.set(1, this.decodeInteger() + 2000);
                XSDDatetime.setMonthDay(this.decodeNBitUnsignedInteger(9), cal);
                this.decodeDateTimeTimezone(cal);
                break;
            }
            case dateTime: {
                cal.set(1, this.decodeInteger() + 2000);
                XSDDatetime.setMonthDay(this.decodeNBitUnsignedInteger(9), cal);
                XSDDatetime.setTime(this.decodeNBitUnsignedInteger(17), cal);
                this.decodeDateTimeFractionalSecs(cal);
                this.decodeDateTimeTimezone(cal);
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                XSDDatetime.setMonthDay(this.decodeNBitUnsignedInteger(9), cal);
                this.decodeDateTimeTimezone(cal);
                break;
            }
            case time: {
                XSDDatetime.setTime(this.decodeNBitUnsignedInteger(17), cal);
                this.decodeDateTimeFractionalSecs(cal);
                this.decodeDateTimeTimezone(cal);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return cal;
    }

    public String decodeDateTimeAsString(DatetimeType type) throws IOException {
        this.sb.setLength(0);
        switch (type) {
            case gYear: {
                XSDDatetime.appendYear(this.sb, this.decodeInteger() + 2000);
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case gYearMonth: {
                XSDDatetime.appendYear(this.sb, this.decodeInteger() + 2000);
                XSDDatetime.appendMonth(this.sb, this.decodeNBitUnsignedInteger(9));
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case date: {
                XSDDatetime.appendYear(this.sb, this.decodeInteger() + 2000);
                XSDDatetime.appendMonthDay(this.sb, this.decodeNBitUnsignedInteger(9));
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case dateTime: {
                XSDDatetime.appendYear(this.sb, this.decodeInteger() + 2000);
                XSDDatetime.appendMonthDay(this.sb, this.decodeNBitUnsignedInteger(9));
                this.sb.append('T');
                XSDDatetime.appendTime(this.sb, this.decodeNBitUnsignedInteger(17));
                this.decodeDateTimeFractionalSecs(this.sb);
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case gMonth: {
                this.sb.append('-');
                XSDDatetime.appendMonth(this.sb, this.decodeNBitUnsignedInteger(9));
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case gMonthDay: {
                this.sb.append('-');
                XSDDatetime.appendMonthDay(this.sb, this.decodeNBitUnsignedInteger(9));
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case gDay: {
                this.sb.append('-');
                this.sb.append('-');
                XSDDatetime.appendDay(this.sb, this.decodeNBitUnsignedInteger(9));
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            case time: {
                XSDDatetime.appendTime(this.sb, this.decodeNBitUnsignedInteger(17));
                this.decodeDateTimeFractionalSecs(this.sb);
                this.decodeDateTimeTimezone(this.sb);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.sb.toString();
    }

    private void decodeDateTimeTimezone(Calendar cal) throws IOException {
        int tz = 0;
        if (this.decodeBoolean()) {
            tz = XSDDatetime.getTimeZoneInMillisecs(this.decodeNBitUnsignedInteger(11) - 840);
        }
        TimeZone tzO = TimeZone.getTimeZone("GMT+00:00");
        tzO.setRawOffset(tz);
        cal.setTimeZone(tzO);
    }

    private void decodeDateTimeTimezone(StringBuilder sbCal) throws IOException {
        if (this.decodeBoolean()) {
            int tz = this.decodeNBitUnsignedInteger(11) - 840;
            XSDDatetime.appendTimezone(sbCal, tz);
        }
    }

    private void decodeDateTimeFractionalSecs(Calendar cal) throws IOException {
        cal.set(14, this.decodeBoolean() ? this.decodeUnsignedInteger() : 0);
    }

    private void decodeDateTimeFractionalSecs(StringBuilder sbCal) throws IOException {
        XSDDatetime.appendFractionalSeconds(sbCal, this.decodeBoolean() ? this.decodeUnsignedInteger() : 0);
    }
}

