/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.util.datatype;

import com.siemens.ct.exi.exceptions.XMLParsingException;

public class XSDFloat {
    public static final long FLOAT_SPECIAL_VALUES = -16384L;
    public static final long MANTISSA_INFINITY = 1L;
    public static final long MANTISSA_MINUS_INFINITY = -1L;
    public static final long MANTISSA_NOT_A_NUMBER = 0L;
    public long iMantissa;
    public long iExponent;

    private XSDFloat() {
    }

    public static XSDFloat newInstance() {
        return new XSDFloat();
    }

    public void parse(String s) throws XMLParsingException {
        if (s.length() == 0) {
            throw new XMLParsingException("Empty string while parsing float");
        }
        if (s.equals("INF")) {
            this.iMantissa = 1L;
            this.iExponent = -16384L;
        } else if (s.equals("-INF")) {
            this.iMantissa = -1L;
            this.iExponent = -16384L;
        } else if (s.equals("NaN")) {
            this.iMantissa = 0L;
            this.iExponent = -16384L;
        } else {
            char[] chars = s.toCharArray();
            int decimalDigits = 0;
            int len = chars.length;
            int pos = 0;
            this.iMantissa = 0L;
            this.iExponent = 0L;
            boolean negative = false;
            boolean negativeExponent = false;
            char c = chars[pos];
            if (c == '+') {
                ++pos;
            } else if (c == '-') {
                negative = true;
                ++pos;
            }
            while (pos < len && (c = chars[pos++]) != '.' && c != 'e' && c != 'E') {
                if (c == '0') {
                    this.iMantissa *= 10L;
                    continue;
                }
                if (c > '0' && c <= '9') {
                    this.iMantissa = 10L * this.iMantissa + (long)(c - 48);
                    continue;
                }
                throw new XMLParsingException("Illegal character while parsing float: " + c + " at pos " + (pos - 1));
            }
            if (c == '.') {
                while (pos < len && (c = chars[pos++]) != 'e' && c != 'E') {
                    if (c == '0') {
                        this.iMantissa *= 10L;
                        ++decimalDigits;
                        continue;
                    }
                    if (c > '0' && c <= '9') {
                        this.iMantissa = 10L * this.iMantissa + (long)(c - 48);
                        ++decimalDigits;
                        continue;
                    }
                    throw new XMLParsingException("Illegal character while parsing float: " + c + " at pos " + (pos - 1));
                }
            }
            if (c == 'e' || c == 'E') {
                c = chars[pos];
                if (c == '-') {
                    negativeExponent = true;
                    ++pos;
                } else if (c == '+') {
                    ++pos;
                }
                while (pos < len) {
                    if ((c = chars[pos++]) >= '0' && c <= '9') {
                        this.iExponent = 10L * this.iExponent + (long)(c - 48);
                        continue;
                    }
                    throw new XMLParsingException("Illegal character while parsing float: " + c + " at pos " + (pos - 1));
                }
                if (negativeExponent) {
                    this.iExponent = -this.iExponent;
                }
            }
            if (pos != len) {
                throw new XMLParsingException("Illegal character while parsing float: " + c + " at pos " + (pos - 1));
            }
            this.iExponent -= (long)decimalDigits;
            if (negative) {
                this.iMantissa = -this.iMantissa;
            }
            if (this.iMantissa == 0L) {
                this.iExponent = 0L;
            }
        }
    }
}

