/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXIDecoder;
import com.siemens.ct.exi.core.EXIHeader;
import com.siemens.ct.exi.core.RuntimeURIEntry;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.event.StartElementNS;
import com.siemens.ct.exi.io.channel.BitDecoderChannel;
import com.siemens.ct.exi.io.channel.ByteDecoderChannel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;

public class EXIDecoderInOrder
extends AbstractEXIDecoder {
    static final QName xsiNilQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
    static final QName xsiTypeQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");

    public EXIDecoderInOrder(EXIFactory exiFactory) {
        super(exiFactory);
    }

    public void setInputStream(InputStream is, boolean exiBodyOnly) throws EXIException, IOException {
        if (!(is instanceof BufferedInputStream)) {
            this.is = is = new BufferedInputStream(is);
        }
        if (!exiBodyOnly) {
            BitDecoderChannel headerChannel = new BitDecoderChannel(is);
            EXIHeader.parse(headerChannel);
        }
        if (this.exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.channel = new BitDecoderChannel(is);
        } else {
            assert (this.exiFactory.getCodingMode() == CodingMode.BYTE_PACKED);
            this.channel = new ByteDecoderChannel(is);
        }
        this.initForEachRun();
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.nextEvent = null;
        this.nextEventType = EventType.START_DOCUMENT;
    }

    public boolean hasNext() throws EXIException, IOException {
        this.decodeEventCode();
        return this.nextEventType != EventType.END_DOCUMENT;
    }

    public EventType next() throws EXIException {
        return this.nextEventType;
    }

    public void decodeStartDocument() throws EXIException {
        this.currentRule = this.currentRule.lookFor((int)this.ec).next;
        if (!this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES") && this.grammar.isSchemaInformed() && this.runtimeURIEntries.size() > 4) {
            RuntimeURIEntry uc = (RuntimeURIEntry)this.runtimeURIEntries.get(4);
            this.namespaces.declarePrefix("", uc.namespaceURI);
            int i = 5;
            while (i < this.runtimeURIEntries.size()) {
                uc = (RuntimeURIEntry)this.runtimeURIEntries.get(i);
                String string = this.getUniquePrefix(uc.namespaceURI);
                ++i;
            }
        }
    }

    public void decodeStartElement() throws EXIException, IOException {
        assert (this.nextEventType == EventType.START_ELEMENT);
        StartElement se = (StartElement)this.nextEvent;
        this.elementQName = se.getQName();
        this.elementPrefix = this.decodeQNamePrefix(this.elementQName);
        this.pushElement(se, this.nextRule);
    }

    public void decodeStartElementNS() throws EXIException, IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_NS);
        StartElementNS seNS = (StartElementNS)this.nextEvent;
        this.elementQName = this.readLocalName(seNS.getNamespaceURI());
        this.elementPrefix = this.decodeQNamePrefix(this.elementQName);
        StartElement nextSE = this.getGenericStartElement(this.elementQName);
        this.pushElement(nextSE, this.nextRule);
    }

    public void decodeStartElementGeneric() throws EXIException, IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_GENERIC);
        this.decodeStartElementExpandedName();
        this.elementPrefix = this.decodeQNamePrefix(this.elementQName);
        StartElement nextSE = this.getGenericStartElement(this.elementQName);
        this.currentRule.learnStartElement(nextSE);
        this.pushElement(nextSE, this.nextRule.getElementContentRule());
    }

    public void decodeStartElementGenericUndeclared() throws EXIException, IOException {
        assert (this.nextEventType == EventType.START_ELEMENT_GENERIC_UNDECLARED);
        this.decodeStartElementExpandedName();
        this.elementPrefix = this.decodeQNamePrefix(this.elementQName);
        StartElement nextSE = this.getGenericStartElement(this.elementQName);
        this.currentRule.learnStartElement(nextSE);
        this.pushElement(nextSE, this.currentRule.getElementContentRule());
    }

    public void decodeNamespaceDeclaration() throws EXIException, IOException {
        this.nsURI = this.readUri();
        this.nsPrefix = this.readPrefix(this.nsURI);
        boolean local_element_ns = this.channel.decodeBoolean();
        if (local_element_ns) {
            this.elementPrefix = this.nsPrefix;
        }
        this.namespaces.declarePrefix(this.nsPrefix, this.nsURI);
    }

    public void decodeAttributeXsiNil() throws EXIException, IOException {
        assert (this.nextEventType == EventType.ATTRIBUTE_XSI_NIL);
        this.attributeQName = xsiNilQName;
        this.attributePrefix = this.decodeQNamePrefix(xsiNilQName);
        this.decodeAttributeXsiNilStructure();
    }

    public void decodeAttributeXsiType() throws EXIException, IOException {
        assert (this.nextEventType == EventType.ATTRIBUTE_XSI_TYPE);
        this.attributeQName = xsiTypeQName;
        this.attributePrefix = this.decodeQNamePrefix(xsiTypeQName);
        this.decodeAttributeXsiTypeStructure();
    }

    protected void readAttributeContent(Datatype dt) throws IOException {
        this.attributeValue = this.typeDecoder.readValue(dt, this.attributeQName, this.channel);
    }

    public void decodeAttribute() throws EXIException, IOException {
        this.readAttributeContent(this.decodeAttributeStructure());
    }

    public void decodeAttributeNS() throws EXIException, IOException {
        this.readAttributeContent(this.decodeAttributeNSStructure());
    }

    public void decodeAttributeInvalidValue() throws EXIException, IOException {
        this.readAttributeContent(this.decodeAttributeInvalidValueStructure());
    }

    public void decodeAttributeAnyInvalidValue() throws EXIException, IOException {
        this.readAttributeContent(this.decodeAttributeAnyInvalidValueStructure());
    }

    public void decodeAttributeGeneric() throws EXIException, IOException {
        this.readAttributeContent(this.decodeAttributeGenericStructure());
    }

    public void decodeAttributeGenericUndeclared() throws EXIException, IOException {
        this.readAttributeContent(this.decodeAttributeGenericUndeclaredStructure());
    }

    public void decodeCharacters() throws EXIException, IOException {
        this.characters = this.typeDecoder.readValue(this.decodeCharactersStructureOnly(), this.elementContext.qname, this.channel);
    }

    public void decodeCharactersGeneric() throws EXIException, IOException {
        this.characters = this.typeDecoder.readValue(this.decodeCharactersGenericStructureOnly(), this.elementContext.qname, this.channel);
    }

    public void decodeCharactersGenericUndeclared() throws EXIException, IOException {
        this.characters = this.typeDecoder.readValue(this.decodeCharactersGenericUndeclaredStructureOnly(), this.elementContext.qname, this.channel);
    }

    public void decodeEndElement() throws EXIException, IOException {
        this.elementQName = this.elementContext.qname;
        this.popElement();
    }

    public void decodeEndElementUndeclared() throws EXIException, IOException {
        this.elementQName = this.elementContext.qname;
        this.currentRule.learnEndElement();
        this.popElement();
    }

    public void decodeEndDocument() throws EXIException, IOException {
    }

    public void decodeDocType() throws EXIException, IOException {
        this.docTypeName = new String(this.channel.decodeString());
        this.docTypePublicID = new String(this.channel.decodeString());
        this.docTypeSystemID = new String(this.channel.decodeString());
        this.docTypeText = new String(this.channel.decodeString());
    }

    public void decodeEntityReference() throws EXIException, IOException {
        this.entityReferenceName = new String(this.channel.decodeString());
    }

    public void decodeComment() throws EXIException, IOException {
        this.comment = this.channel.decodeString();
        this.currentRule = this.currentRule.getElementContentRule();
    }

    public void decodeProcessingInstruction() throws EXIException, IOException {
        this.piTarget = new String(this.channel.decodeString());
        this.piData = new String(this.channel.decodeString());
        this.currentRule = this.currentRule.getElementContentRule();
    }
}

