/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class NBitIntegerDatatype
extends AbstractDatatype {
    private int valueToEncode;
    protected final int lowerBound;
    protected final int upperBound;
    protected final int numberOfBits4Range;

    public NBitIntegerDatatype(QName datatypeIdentifier, int lowerBound, int upperBound, int boundedRange) {
        super(BuiltInType.NBIT_INTEGER, datatypeIdentifier);
        this.rcs = new XSDIntegerCharacterSet();
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.numberOfBits4Range = MethodsBag.getCodingLength(boundedRange);
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getNumberOfBits() {
        return this.numberOfBits4Range;
    }

    public boolean isValid(String value) {
        try {
            this.valueToEncode = Integer.parseInt(value);
            if (this.valueToEncode >= this.lowerBound && this.valueToEncode <= this.upperBound) {
                this.valueToEncode -= this.lowerBound;
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.valueToEncode, this.numberOfBits4Range);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        IntegerValue iv = valueChannel.decodeNBitUnsignedIntegerValue(this.numberOfBits4Range);
        if (this.lowerBound != 0) {
            iv = new IntegerValue(iv.toInteger() + this.lowerBound);
        }
        return iv;
    }
}

