/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.LongValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class NBitLongDatatype
extends AbstractDatatype {
    protected final long lowerBound;
    protected final long upperBound;
    protected final int numberOfBits4Range;
    private int valueToEncode;

    public NBitLongDatatype(QName datatypeIdentifier, long lowerBound, long upperBound, int boundedRange) {
        super(BuiltInType.NBIT_LONG, datatypeIdentifier);
        this.rcs = new XSDIntegerCharacterSet();
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.numberOfBits4Range = MethodsBag.getCodingLength(boundedRange);
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public int getNumberOfBits() {
        return this.numberOfBits4Range;
    }

    public boolean isValid(String value) {
        try {
            long lValueToEncode = Long.parseLong(value);
            if (lValueToEncode >= this.lowerBound && lValueToEncode <= this.upperBound) {
                assert ((lValueToEncode -= this.lowerBound) <= Integer.MAX_VALUE);
                this.valueToEncode = (int)lValueToEncode;
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.valueToEncode, this.numberOfBits4Range);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        int decodedValue = valueChannel.decodeNBitUnsignedInteger(this.numberOfBits4Range);
        LongValue lv = this.lowerBound == 0L ? new LongValue(decodedValue) : new LongValue((long)decodedValue + this.lowerBound);
        return lv;
    }
}

