/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.channel.AbstractEncoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import java.io.IOException;
import java.io.OutputStream;

public final class ByteEncoderChannel
extends AbstractEncoderChannel
implements EncoderChannel {
    private final OutputStream os;

    public ByteEncoderChannel(OutputStream os) {
        this.os = os;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void align() throws IOException {
    }

    public void encode(int b) throws IOException {
        this.os.write(b);
    }

    public void encode(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public void encodeBoolean(boolean b) throws IOException, IllegalArgumentException {
        this.encode(b ? 1 : 0);
    }

    public void encodeNBitUnsignedInteger(int b, int n) throws IOException {
        if (b < 0 || n < 0) {
            throw new IllegalArgumentException("Negative value as unsigned integer!");
        }
        assert (b >= 0);
        assert (n >= 0);
        if (n != 0) {
            if (n < 9) {
                this.encode(b & 0xFF);
            } else if (n < 17) {
                this.encode(b & 0xFF);
                this.encode((b & 0xFF00) >> 8);
            } else if (n < 25) {
                this.encode(b & 0xFF);
                this.encode((b & 0xFF00) >> 8);
                this.encode((b & 0xFF0000) >> 16);
            } else if (n < 33) {
                this.encode(b & 0xFF);
                this.encode((b & 0xFF00) >> 8);
                this.encode((b & 0xFF0000) >> 16);
                this.encode((b & 0xFF000000) >> 24);
            } else {
                throw new RuntimeException("Currently not more than 4 Bytes allowed for NBitUnsignedInteger!");
            }
        }
    }
}

