/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.exceptions.UnsupportedOption;
import java.util.HashSet;
import java.util.Set;

public class FidelityOptions {
    public static final String FEATURE_COMMENT = "PRESERVE_COMMENTS";
    public static final String FEATURE_PI = "PRESERVE_PIS";
    public static final String FEATURE_DTD = "PRESERVE_DTDS";
    public static final String FEATURE_PREFIX = "PRESERVE_PREFIXES";
    public static final String FEATURE_XSI_SCHEMALOCATION = "PRESERVE_XSI_SCHEMALOCATION";
    public static final String FEATURE_LEXICAL_VALUE = "PRESERVE_LEXICAL_VALUES";
    public static final String FEATURE_WS = "PRESERVE_WHITESPACES";
    public static final String FEATURE_SC = "SELF_CONTAINED";
    public static final String FEATURE_STRICT = "STRICT";
    protected Set<String> options = new HashSet<String>();
    protected boolean isStrict = false;

    protected FidelityOptions() {
    }

    public static FidelityOptions createDefault() {
        FidelityOptions fo = new FidelityOptions();
        return fo;
    }

    public static FidelityOptions createStrict() {
        FidelityOptions fo = new FidelityOptions();
        fo.options.add(FEATURE_STRICT);
        fo.isStrict = true;
        return fo;
    }

    public static FidelityOptions createAll() {
        FidelityOptions fo = new FidelityOptions();
        fo.options.add(FEATURE_COMMENT);
        fo.options.add(FEATURE_PI);
        fo.options.add(FEATURE_DTD);
        fo.options.add(FEATURE_PREFIX);
        fo.options.add(FEATURE_LEXICAL_VALUE);
        fo.options.add(FEATURE_WS);
        fo.options.add(FEATURE_SC);
        fo.options.add(FEATURE_XSI_SCHEMALOCATION);
        return fo;
    }

    public void setFidelity(String key, boolean decision) throws UnsupportedOption {
        if (key.equals(FEATURE_STRICT)) {
            if (decision) {
                boolean prevContainedLexVal = this.options.contains(FEATURE_LEXICAL_VALUE);
                this.options.clear();
                if (prevContainedLexVal) {
                    this.options.add(FEATURE_LEXICAL_VALUE);
                }
                this.options.add(FEATURE_STRICT);
                this.isStrict = true;
            } else {
                this.options.remove(key);
                this.isStrict = false;
            }
        } else if (key.equals(FEATURE_LEXICAL_VALUE)) {
            if (decision) {
                this.options.add(key);
            } else {
                this.options.remove(key);
            }
        } else if (key.equals(FEATURE_COMMENT) || key.equals(FEATURE_PI) || key.equals(FEATURE_DTD) || key.equals(FEATURE_PREFIX) || key.equals(FEATURE_WS) || key.equals(FEATURE_SC)) {
            if (decision) {
                if (this.isStrict()) {
                    this.options.remove(FEATURE_STRICT);
                    this.isStrict = false;
                }
                this.options.add(key);
            } else {
                this.options.remove(key);
            }
        } else {
            throw new UnsupportedOption("FidelityOption '" + key + "' is unknown!");
        }
    }

    public boolean isFidelityEnabled(String key) {
        return this.options.contains(key);
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean equals(Object o) {
        if (o instanceof FidelityOptions) {
            FidelityOptions other = (FidelityOptions)o;
            return this.options.equals(other.options);
        }
        return false;
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return this.options.toString();
    }
}

