/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar;

import com.siemens.ct.exi.grammar.AbstractGrammar;
import com.siemens.ct.exi.grammar.GrammarURIEntry;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.StartDocument;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.DocEnd;
import com.siemens.ct.exi.grammar.rule.Document;
import com.siemens.ct.exi.grammar.rule.Fragment;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedDocContent;
import com.siemens.ct.exi.grammar.rule.SchemaInformedFragmentContent;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaInformedGrammar
extends AbstractGrammar {
    protected List<StartElement> sortedGlobalElements;
    protected Map<QName, StartElement> globalElements;
    protected Map<QName, Attribute> globalAttributes;
    protected Map<QName, TypeGrammar> grammarTypes;
    protected SchemaInformedRule builtInFragmentGrammar;

    protected SchemaInformedGrammar(GrammarURIEntry[] additionalSchemaEntries, List<StartElement> fragmentElements, List<StartElement> sortedGlobalElements) {
        super(true);
        this.sortedGlobalElements = sortedGlobalElements;
        boolean hasEmptyURIEntries = SchemaInformedGrammar.containsEmptyURI(additionalSchemaEntries);
        int uriSize = hasEmptyURIEntries ? 4 + additionalSchemaEntries.length - 1 : 4 + additionalSchemaEntries.length;
        this.grammarEntries = new GrammarURIEntry[uriSize];
        if (hasEmptyURIEntries) {
            assert (additionalSchemaEntries[0].uri.equals(""));
            this.grammarEntries[0] = additionalSchemaEntries[0];
        } else {
            this.grammarEntries[0] = SchemaInformedGrammar.getURIEntryForEmpty();
        }
        this.grammarEntries[1] = SchemaInformedGrammar.getURIEntryForXML();
        this.grammarEntries[2] = SchemaInformedGrammar.getURIEntryForXSI();
        this.grammarEntries[3] = SchemaInformedGrammar.getURIEntryForXSD();
        int diff = hasEmptyURIEntries ? 3 : 4;
        int index = 4;
        while (index - diff < additionalSchemaEntries.length) {
            this.grammarEntries[index] = additionalSchemaEntries[index - diff];
            ++index;
        }
        this.initDocumentGrammar();
        this.initFragmentGrammar(fragmentElements);
        this.globalElements = new HashMap<QName, StartElement>();
        for (StartElement globalElement : sortedGlobalElements) {
            this.globalElements.put(globalElement.getQName(), globalElement);
        }
    }

    protected static boolean containsEmptyURI(GrammarURIEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].uri.equals("")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public StartElement getGlobalElement(QName qname) {
        for (StartElement globalElement : this.sortedGlobalElements) {
            if (!globalElement.getQName().equals(qname)) continue;
            return globalElement;
        }
        return null;
    }

    protected void setGlobalAttributes(Map<QName, Attribute> globalAttributes) {
        assert (globalAttributes != null);
        this.globalAttributes = globalAttributes;
    }

    @Override
    public Attribute getGlobalAttribute(QName qname) {
        return this.globalAttributes.get(qname);
    }

    protected void setTypeGrammars(Map<QName, TypeGrammar> grammarTypes) {
        assert (grammarTypes != null);
        this.grammarTypes = grammarTypes;
    }

    @Override
    public TypeGrammar getTypeGrammar(QName qname) {
        return this.grammarTypes.get(qname);
    }

    protected void initDocumentGrammar() {
        DocEnd builtInDocEndGrammar = new DocEnd("DocEnd");
        SchemaInformedDocContent builtInDocContentGrammar = new SchemaInformedDocContent(builtInDocEndGrammar, "DocContent");
        for (StartElement globalElement : this.sortedGlobalElements) {
            builtInDocContentGrammar.addRule(globalElement, builtInDocEndGrammar);
        }
        this.builtInDocumentGrammar = new Document(builtInDocContentGrammar, "Document");
    }

    protected void initFragmentGrammar(List<StartElement> namedElements) {
        SchemaInformedFragmentContent builtInFragmentContentGrammar = new SchemaInformedFragmentContent("FragmentContent");
        for (StartElement namedElement : namedElements) {
            builtInFragmentContentGrammar.addRule(namedElement, builtInFragmentContentGrammar);
        }
        this.builtInFragmentGrammar = new Fragment(builtInFragmentContentGrammar, "Fragment");
        this.builtInFragmentGrammar.addRule(new StartDocument(), builtInFragmentContentGrammar);
    }

    @Override
    public Rule getBuiltInFragmentGrammar() {
        return this.builtInFragmentGrammar;
    }
}

