/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXIDecoder;
import com.siemens.ct.exi.datatype.decoder.TypeDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableDecoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.GrammarSchemaInformed;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartDocument;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EXIDecoderInOrder
extends AbstractEXIDecoder {
    protected List<StringTableDecoder> scStringTables;
    protected List<Map<String, Map<String, Rule>>> scRuntimeDispatchers;

    public EXIDecoderInOrder(EXIFactory exiFactory) {
        super(exiFactory);
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            this.scStringTables = new ArrayList<StringTableDecoder>();
            this.scRuntimeDispatchers = new ArrayList<Map<String, Map<String, Rule>>>();
        }
    }

    protected void initForEachRun() throws EXIException {
        super.initForEachRun();
        this.nextEvent = new StartDocument();
        this.nextEventType = EventType.START_DOCUMENT;
        if (this.exiFactory.isFragment()) {
            this.pushRule(this.grammar.getBuiltInFragmentGrammar());
        } else {
            this.pushRule(this.grammar.getBuiltInDocumentGrammar());
        }
    }

    public void inspectEvent() throws EXIException {
        this.decodeEventCode();
    }

    public boolean hasNextEvent() {
        return this.nextEventType != EventType.END_DOCUMENT || this.openRules.size() != 2;
    }

    public EventType getNextEventType() {
        return this.nextEventType;
    }

    public void decodeStartDocument() throws EXIException {
        this.decodeStartDocumentStructure();
    }

    public void decodeStartElement() throws EXIException {
        this.decodeStartElementStructure();
    }

    public void decodeStartElementGeneric() throws EXIException {
        this.decodeStartElementGenericStructure();
    }

    public void decodeStartElementGenericUndeclared() throws EXIException {
        this.decodeStartElementGenericUndeclaredStructure();
    }

    public void decodeNamespaceDeclaration() throws EXIException {
        this.decodeNamespaceDeclarationStructure();
    }

    public void decodeAttribute() throws EXIException {
        try {
            this.attributeValue = this.block.readTypedValidValue(this.decodeAttributeStructure().getDatatype(), this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeAttributeInvalidValue() throws EXIException {
        this.decodeAttributeStructure();
        try {
            this.attributeValue = this.block.readValueAsString(this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeAttributeGeneric() throws EXIException {
        try {
            this.decodeAttributeGenericStructure();
            this.attributeValue = this.block.readValueAsString(this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeAttributeGenericUndeclared() throws EXIException {
        try {
            this.decodeAttributeGenericUndeclaredStructure();
            this.attributeValue = this.block.readValueAsString(this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeXsiType() throws EXIException {
        this.decodeAttributeXsiType();
        TypeGrammar tg = ((GrammarSchemaInformed)this.grammar).getTypeGrammar(this.xsiTypeUri, this.xsiTypeName);
        if (tg != null) {
            this.replaceRuleAtTheTop(tg.getType());
            this.pushScopeType(this.xsiTypeUri, this.xsiTypeName);
        }
    }

    public void decodeXsiNil() throws EXIException {
        this.decodeAttributeXsiNil();
        if (this.xsiNil) {
            if (this.currentRule instanceof SchemaInformedRule) {
                this.replaceRuleAtTheTop(((SchemaInformedRule)this.currentRule).getTypeEmpty());
            } else {
                throw new EXIException("EXI, no typeEmpty for xsi:nil");
            }
        }
    }

    public void decodeXsiNilDeviation() throws EXIException {
        this.decodeAttributeXsiNilDeviation();
    }

    public void decodeCharacters() throws EXIException {
        try {
            this.characters = this.block.readTypedValidValue(this.decodeCharactersStructure().getDatatype(), this.getScopeURI(), this.getScopeLocalName());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeCharactersGenericValue() throws EXIException {
        try {
            this.characters = this.block.readValueAsString(this.getScopeURI(), this.getScopeLocalName());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeCharactersGeneric() throws EXIException {
        this.decodeCharactersGenericStructure();
        this.decodeCharactersGenericValue();
    }

    public void decodeCharactersGenericUndeclared() throws EXIException {
        this.decodeCharactersUndeclaredStructure();
        this.decodeCharactersGenericValue();
    }

    public void decodeEndElement() throws EXIException {
        this.decodeEndElementStructure();
    }

    public void decodeEndElementUndeclared() throws EXIException {
        this.decodeEndElementUndeclaredStructure();
    }

    public void decodeEndDocument() throws EXIException {
        this.decodeEndDocumentStructure();
    }

    public void decodeDocType() throws EXIException {
        this.decodeDocTypeStructure();
    }

    public void decodeEntityReference() throws EXIException {
        this.decodeEntityReferenceStructure();
    }

    public void decodeComment() throws EXIException {
        this.decodeCommentStructure();
    }

    public void decodeProcessingInstruction() throws EXIException {
        this.decodeProcessingInstructionStructure();
    }

    public void decodeStartFragmentSelfContained() throws EXIException {
        try {
            this.block.skipToNextByteBoundary();
            TypeDecoder td = this.block.getTypeDecoder();
            this.scStringTables.add(td.getStringTable());
            td.setStringTable(this.exiFactory.createTypeDecoder().getStringTable());
            this.scRuntimeDispatchers.add(this.runtimeDispatcher);
            this.runtimeDispatcher = new HashMap();
            this.replaceRuleAtTheTop(this.grammar.getBuiltInFragmentGrammar());
            this.replaceRuleAtTheTop(this.currentRule.get1stLevelRule(0));
            this.inspectEvent();
            this.decodeStartElement();
            this.popScope();
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeEndFragmentSelfContained() throws EXIException {
        this.decodeEndDocument();
        TypeDecoder td = this.block.getTypeDecoder();
        td.setStringTable(this.scStringTables.remove(this.scStringTables.size() - 1));
        this.runtimeDispatcher = this.scRuntimeDispatchers.remove(this.scRuntimeDispatchers.size() - 1);
    }
}

