/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.encoder;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.encoder.AbstractDatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.DatatypeEncoder;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.datatype.XSDInteger;
import java.io.IOException;

public class UnsignedIntegerDatatypeEncoder
extends AbstractDatatypeEncoder
implements DatatypeEncoder {
    private XSDInteger lastUnsignedInteger = XSDInteger.newInstance();

    public UnsignedIntegerDatatypeEncoder(TypeEncoder typeEncoder) {
        super(typeEncoder);
    }

    public boolean isValid(Datatype datatype, String value) {
        try {
            this.lastUnsignedInteger.parse(value);
            return !this.lastUnsignedInteger.isNegative();
        }
        catch (XMLParsingException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, String uri, String localName) throws IOException {
        valueChannel.encodeUnsignedInteger(this.lastUnsignedInteger);
    }
}

