/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.stringtable;

import com.siemens.ct.exi.datatype.stringtable.AbstractStringTable;
import com.siemens.ct.exi.datatype.stringtable.StringTableDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTablePartitionDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTablePartitionDecoderImpl;
import com.siemens.ct.exi.datatype.stringtable.StringTablePartitionEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTableDecoderImpl
extends AbstractStringTable
implements StringTableDecoder {
    protected StringTablePartitionDecoder uriPartition = this.getNewPartition();
    protected Map<String, StringTablePartitionDecoder> prefixPartitions = new HashMap<String, StringTablePartitionDecoder>();
    protected Map<String, StringTablePartitionDecoder> localNamePartitions = new HashMap<String, StringTablePartitionDecoder>();
    protected Map<String, HashMap<String, StringTablePartitionDecoder>> localValuePartitions = new HashMap<String, HashMap<String, StringTablePartitionDecoder>>();
    protected StringTablePartitionDecoder globalValuePartition = this.getNewPartition();

    public StringTableDecoderImpl(boolean isSchemaInformed) {
        this.initURI(this.uriPartition, isSchemaInformed);
        this.prefixPartitions.put("", this.getNewPartition());
        this.prefixPartitions.put("http://www.w3.org/XML/1998/namespace", this.getNewPartition());
        this.prefixPartitions.put("http://www.w3.org/2001/XMLSchema-instance", this.getNewPartition());
        this.initPrefixEmpty(this.prefixPartitions.get(""));
        this.initPrefixXML(this.prefixPartitions.get("http://www.w3.org/XML/1998/namespace"));
        this.initPrefixXSI(this.prefixPartitions.get("http://www.w3.org/2001/XMLSchema-instance"));
        this.localNamePartitions.put("http://www.w3.org/XML/1998/namespace", this.getNewPartition());
        this.localNamePartitions.put("http://www.w3.org/2001/XMLSchema-instance", this.getNewPartition());
        this.localNamePartitions.put("http://www.w3.org/2001/XMLSchema", this.getNewPartition());
        this.initLocalNameXML(this.localNamePartitions.get("http://www.w3.org/XML/1998/namespace"));
        this.initLocalNameXSI(this.localNamePartitions.get("http://www.w3.org/2001/XMLSchema-instance"));
        this.initLocalNameXSD(this.localNamePartitions.get("http://www.w3.org/2001/XMLSchema"));
    }

    protected StringTablePartitionDecoder getNewPartition() {
        return new StringTablePartitionDecoderImpl();
    }

    protected int getID(StringTablePartitionEncoder partition, String key) {
        return partition == null ? -1 : partition.getIndex(key);
    }

    protected StringTablePartitionDecoder getPartition(Map<String, StringTablePartitionDecoder> partitions, String key) {
        StringTablePartitionDecoder partition = partitions.get(key);
        if (partition == null) {
            partition = this.getNewPartition();
            partitions.put(key, partition);
        }
        return partition;
    }

    @Override
    public String getURIValue(int id) {
        return this.uriPartition.getValue(id);
    }

    @Override
    public String getPrefixValue(String uri, int id) {
        return this.prefixPartitions.get(uri).getValue(id);
    }

    @Override
    public String getLocalNameValue(String uri, int id) {
        return this.localNamePartitions.get(uri).getValue(id);
    }

    @Override
    public String getLocalValue(String uri, String localName, int id) {
        assert (this.localValuePartitions.get(uri).size() > 0);
        assert (this.localValuePartitions.get(uri).get(localName).getSize() > 0);
        return this.localValuePartitions.get(uri).get(localName).getValue(id);
    }

    @Override
    public String getGlobalValue(int id) {
        return this.globalValuePartition.getValue(id);
    }

    @Override
    public void addURI(String uri) {
        this.uriPartition.add(uri);
    }

    @Override
    public int getURITableSize() {
        return this.uriPartition.getSize();
    }

    @Override
    public void addPrefix(String uri, String prefix) {
        this.getPartition(this.prefixPartitions, uri).add(prefix);
    }

    @Override
    public int getPrefixTableSize(String uri) {
        return this.getPartition(this.prefixPartitions, uri).getSize();
    }

    @Override
    public void addLocalName(String uri, String name) {
        this.getPartition(this.localNamePartitions, uri).add(name);
    }

    @Override
    public int getLocalNameTableSize(String uri) {
        return this.getPartition(this.localNamePartitions, uri).getSize();
    }

    @Override
    public void addLocalValue(String uri, String localName, String value) {
        HashMap<String, StringTablePartitionDecoder> uriSection = this.localValuePartitions.get(uri);
        if (uriSection == null) {
            uriSection = new HashMap();
            this.localValuePartitions.put(uri, uriSection);
        }
        this.getPartition(uriSection, localName).add(value);
    }

    @Override
    public int getLocalValueTableSize(String uri, String localName) {
        HashMap<String, StringTablePartitionDecoder> uriSection = this.localValuePartitions.get(uri);
        return uriSection == null ? 0 : this.getPartition(uriSection, localName).getSize();
    }

    @Override
    public void addGlobalValue(String value) {
        this.globalValuePartition.add(value);
    }

    @Override
    public int getGlobalValueTableSize() {
        return this.globalValuePartition.getSize();
    }
}

