/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.block;

import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableEncoder;
import com.siemens.ct.exi.io.block.EncoderBlock;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractEncoderBlock
implements EncoderBlock {
    private int blockValues = 0;
    protected OutputStream outputStream;
    TypeEncoder typeEncoder;

    public AbstractEncoderBlock(OutputStream outputStream, TypeEncoder typeEncoder) {
        this.outputStream = outputStream;
        this.typeEncoder = typeEncoder;
        this.init();
    }

    protected abstract void init();

    protected int getNumberOfBlockValues() {
        return this.blockValues;
    }

    protected abstract EncoderChannel getStructureChannel();

    protected abstract EncoderChannel getValueChannel(String var1, String var2);

    public void writeEventCode(int eventCode, int codeLength) throws IOException {
        this.getStructureChannel().encodeNBitUnsignedInteger(eventCode, codeLength);
    }

    public void writeString(String text) throws IOException {
        this.getStructureChannel().encodeString(text);
    }

    public void writeUri(String uri) throws IOException {
        EncoderChannel structure = this.getStructureChannel();
        StringTableEncoder stringTable = this.typeEncoder.getStringTable();
        int uriID = stringTable.getURIID(uri);
        int nUri = MethodsBag.getCodingLength(stringTable.getURITableSize() + 1);
        if (uriID == -1) {
            structure.encodeNBitUnsignedInteger(0, nUri);
            structure.encodeString(uri);
            stringTable.addURI(uri);
        } else {
            structure.encodeNBitUnsignedInteger(uriID + 1, nUri);
        }
    }

    public void writeLocalName(String localName, String uri) throws IOException {
        EncoderChannel structure = this.getStructureChannel();
        StringTableEncoder stringTable = this.typeEncoder.getStringTable();
        int localNameID = stringTable.getLocalNameID(uri, localName);
        if (localNameID == -1) {
            structure.encodeUnsignedInteger(localName.length() + 1);
            structure.encodeStringOnly(localName);
            stringTable.addLocalName(uri, localName);
        } else {
            structure.encodeUnsignedInteger(0);
            int n = MethodsBag.getCodingLength(stringTable.getLocalNameTableSize(uri));
            structure.encodeNBitUnsignedInteger(localNameID, n);
        }
    }

    public void writePrefix(String prefix, String uri) throws IOException {
        EncoderChannel structure = this.getStructureChannel();
        StringTableEncoder stringTable = this.typeEncoder.getStringTable();
        int pfxID = stringTable.getPrefixID(uri, prefix);
        int mPfx = stringTable.getPrefixTableSize(uri);
        int nPfx = MethodsBag.getCodingLength(mPfx + 1);
        if (pfxID == -1) {
            structure.encodeNBitUnsignedInteger(0, nPfx);
            structure.encodeString(prefix);
            stringTable.addPrefix(uri, prefix);
        } else {
            structure.encodeNBitUnsignedInteger(pfxID + 1, nPfx);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.getStructureChannel().encodeBoolean(b);
    }

    public boolean isTypeValid(Datatype datatype, String value) {
        return this.typeEncoder.isTypeValid(datatype, value);
    }

    public void writeTypeValidValue(String uri, String localName) throws IOException {
        ++this.blockValues;
        EncoderChannel valueChannel = this.getValueChannel(uri, localName);
        valueChannel.incrementValues();
        this.typeEncoder.writeTypeValidValue(valueChannel, uri, localName);
    }

    public void writeValueAsString(String uri, String localName, String value) throws IOException {
        ++this.blockValues;
        EncoderChannel valueChannel = this.getValueChannel(uri, localName);
        valueChannel.incrementValues();
        this.typeEncoder.writeValueAsString(valueChannel, uri, localName, value);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public TypeEncoder getTypeEncoder() {
        return this.typeEncoder;
    }

    public void skipToNextByteBoundary() throws IOException {
    }

    public boolean bytePositionSupported() {
        return false;
    }

    public int getBytePosition() {
        return -1;
    }
}

