/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.block;

import com.siemens.ct.exi.datatype.encoder.TypeEncoder;
import com.siemens.ct.exi.io.block.AbstractEncoderBlock;
import com.siemens.ct.exi.io.channel.ByteEncoderChannelChannelized;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannelChannelized;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractEncoderByteBlockChannelized
extends AbstractEncoderBlock {
    protected EncoderChannelChannelized structureChannel;
    protected Map<String, Map<String, EncoderChannelChannelized>> valueChannels;
    protected List<String> orderValueChannelUri;
    protected List<String> orderValueChannelLocalName;

    public AbstractEncoderByteBlockChannelized(OutputStream outputStream, TypeEncoder typeEncoder) {
        super(outputStream, typeEncoder);
    }

    protected void init() {
        this.structureChannel = AbstractEncoderByteBlockChannelized.createEncoderChannel();
        this.valueChannels = new HashMap<String, Map<String, EncoderChannelChannelized>>();
        this.orderValueChannelUri = new ArrayList<String>();
        this.orderValueChannelLocalName = new ArrayList<String>();
    }

    protected void addNewExpandedNameChannel(String uri, String localName) {
        this.orderValueChannelUri.add(uri);
        this.orderValueChannelLocalName.add(localName);
    }

    private static EncoderChannelChannelized createEncoderChannel() {
        return new ByteEncoderChannelChannelized();
    }

    protected EncoderChannel getStructureChannel() {
        return this.structureChannel;
    }

    protected EncoderChannel getValueChannel(String uri, String localName) {
        if (this.valueChannels.containsKey(uri)) {
            Map<String, EncoderChannelChannelized> valueChannelsLocalNamePerURI = this.valueChannels.get(uri);
            if (!valueChannelsLocalNamePerURI.containsKey(localName)) {
                valueChannelsLocalNamePerURI.put(localName, AbstractEncoderByteBlockChannelized.createEncoderChannel());
                this.addNewExpandedNameChannel(uri, localName);
            }
            return valueChannelsLocalNamePerURI.get(localName);
        }
        HashMap<String, EncoderChannelChannelized> valueChannelsLocalNamePerURI = new HashMap<String, EncoderChannelChannelized>();
        valueChannelsLocalNamePerURI.put(localName, AbstractEncoderByteBlockChannelized.createEncoderChannel());
        this.valueChannels.put(uri, valueChannelsLocalNamePerURI);
        this.addNewExpandedNameChannel(uri, localName);
        return (EncoderChannel)valueChannelsLocalNamePerURI.get(localName);
    }

    protected abstract OutputStream getStream() throws IOException;

    protected abstract void finalizeStream() throws IOException;

    public void flush() throws IOException {
        assert (this.orderValueChannelUri.size() == this.orderValueChannelLocalName.size());
        if (this.getNumberOfBlockValues() <= 100) {
            OutputStream singleStream = this.getStream();
            singleStream.write(this.structureChannel.toByteArray());
            int i = 0;
            while (i < this.orderValueChannelUri.size()) {
                singleStream.write(this.valueChannels.get(this.orderValueChannelUri.get(i)).get(this.orderValueChannelLocalName.get(i)).toByteArray());
                ++i;
            }
            this.finalizeStream();
        } else {
            OutputStream structureStream = this.getStream();
            structureStream.write(this.structureChannel.toByteArray());
            this.finalizeStream();
            OutputStream lessEq100Stream = this.getStream();
            boolean wasThereLess100 = false;
            int i = 0;
            while (i < this.orderValueChannelUri.size()) {
                EncoderChannelChannelized channelLEQ100 = this.valueChannels.get(this.orderValueChannelUri.get(i)).get(this.orderValueChannelLocalName.get(i));
                if (channelLEQ100.getNumberOfChannelValues() <= 100) {
                    lessEq100Stream.write(channelLEQ100.toByteArray());
                    wasThereLess100 = true;
                }
                ++i;
            }
            if (wasThereLess100) {
                this.finalizeStream();
            }
            i = 0;
            while (i < this.orderValueChannelUri.size()) {
                EncoderChannelChannelized channelGre100 = this.valueChannels.get(this.orderValueChannelUri.get(i)).get(this.orderValueChannelLocalName.get(i));
                if (channelGre100.getNumberOfChannelValues() > 100) {
                    OutputStream great100Stream = this.getStream();
                    great100Stream.write(channelGre100.toByteArray());
                    this.finalizeStream();
                }
                ++i;
            }
        }
        this.outputStream.flush();
    }
}

