/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.types;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.BigIntegerDatatype;
import com.siemens.ct.exi.datatype.BinaryBase64Datatype;
import com.siemens.ct.exi.datatype.BinaryHexDatatype;
import com.siemens.ct.exi.datatype.BooleanDatatype;
import com.siemens.ct.exi.datatype.BooleanPatternDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatetimeDatatype;
import com.siemens.ct.exi.datatype.DecimalDatatype;
import com.siemens.ct.exi.datatype.DoubleDatatype;
import com.siemens.ct.exi.datatype.EnumerationDatatype;
import com.siemens.ct.exi.datatype.FloatDatatype;
import com.siemens.ct.exi.datatype.IntegerDatatype;
import com.siemens.ct.exi.datatype.ListDatatype;
import com.siemens.ct.exi.datatype.LongDatatype;
import com.siemens.ct.exi.datatype.NBitBigIntegerDatatype;
import com.siemens.ct.exi.datatype.NBitIntegerDatatype;
import com.siemens.ct.exi.datatype.NBitLongDatatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.datatype.StringDatatype;
import com.siemens.ct.exi.datatype.UnsignedBigIntegerDatatype;
import com.siemens.ct.exi.datatype.UnsignedIntegerDatatype;
import com.siemens.ct.exi.datatype.UnsignedLongDatatype;
import com.siemens.ct.exi.datatype.charset.CodePointCharacterSet;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.xpath.regex.EXIRegularExpression;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class BuiltIn {
    public static final int MAX_BOUNDED_NBIT_INTEGER_RANGE = 4096;
    protected static final QName XSD_BASE64BINARY = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
    protected static final QName XSD_HEXBINARY = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");
    public static final QName XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    protected static final QName XSD_DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    protected static final QName XSD_TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    protected static final QName XSD_DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");
    protected static final QName XSD_GYEARMONTH = new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth");
    protected static final QName XSD_GYEAR = new QName("http://www.w3.org/2001/XMLSchema", "gYear");
    protected static final QName XSD_GMONTHDAY = new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay");
    protected static final QName XSD_GDAY = new QName("http://www.w3.org/2001/XMLSchema", "gDay");
    protected static final QName XSD_GMONTH = new QName("http://www.w3.org/2001/XMLSchema", "gMonth");
    protected static final QName XSD_DECIMAL = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
    protected static final QName XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float");
    protected static final QName XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double");
    protected static final QName XSD_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "integer");
    protected static final QName XSD_NON_NEGATIVE_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger");
    protected static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
    protected static final QName XSD_ANY_SIMPLE_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType");
    public static final QName DEFAULT_VALUE_NAME = XSD_STRING;
    public static final BuiltInType DEFAULT_BUILTIN = BuiltInType.STRING;
    public static final Datatype DEFAULT_DATATYPE = new StringDatatype(DEFAULT_VALUE_NAME);
    public static final Datatype BOOLEAN_DATATYPE = new StringDatatype(XSD_BOOLEAN);
    protected static final Map<QName, QName> datatypeMapping = new HashMap<QName, QName>();

    static {
        datatypeMapping.put(XSD_BASE64BINARY, XSD_BASE64BINARY);
        datatypeMapping.put(XSD_HEXBINARY, XSD_HEXBINARY);
        datatypeMapping.put(XSD_BOOLEAN, XSD_BOOLEAN);
        datatypeMapping.put(XSD_DATETIME, XSD_DATETIME);
        datatypeMapping.put(XSD_TIME, XSD_DATETIME);
        datatypeMapping.put(XSD_DATE, XSD_DATETIME);
        datatypeMapping.put(XSD_GYEARMONTH, XSD_DATETIME);
        datatypeMapping.put(XSD_GYEAR, XSD_DATETIME);
        datatypeMapping.put(XSD_GMONTHDAY, XSD_DATETIME);
        datatypeMapping.put(XSD_GDAY, XSD_DATETIME);
        datatypeMapping.put(XSD_GMONTH, XSD_DATETIME);
        datatypeMapping.put(XSD_DECIMAL, XSD_DECIMAL);
        datatypeMapping.put(XSD_FLOAT, XSD_FLOAT);
        datatypeMapping.put(XSD_DOUBLE, XSD_DOUBLE);
        datatypeMapping.put(XSD_INTEGER, XSD_INTEGER);
        datatypeMapping.put(XSD_STRING, XSD_STRING);
        datatypeMapping.put(XSD_ANY_SIMPLE_TYPE, XSD_STRING);
    }

    public static Datatype getDatatype(XSSimpleTypeDefinition std) throws EXIException {
        Datatype datatype = null;
        if (std.getVariety() == 2) {
            XSSimpleTypeDefinition listSTD = std.getItemType();
            Datatype dtList = BuiltIn.getDatatype(listSTD);
            datatype = new ListDatatype(dtList);
        } else if (std.isDefinedFacet((short)2048)) {
            XSObjectList facetList = std.getMultiValueFacets();
            int i = 0;
            while (i < facetList.getLength()) {
                XSMultiValueFacet enumer;
                XSObject facet = facetList.item(i);
                if (facet.getType() == 14 && (enumer = (XSMultiValueFacet)facet).getFacetKind() == 2048) {
                    StringList enumList = enumer.getLexicalFacetValues();
                    datatype = new EnumerationDatatype(enumList);
                }
                ++i;
            }
        } else {
            datatype = BuiltIn.getDatatypeOfType(std);
        }
        return datatype;
    }

    private static QName getXMLSchemaDatatype(XSSimpleTypeDefinition std) {
        QName exiDatatypeID;
        QName primitive = BuiltIn.getPrimitive(std);
        if (primitive.equals(XSD_DECIMAL)) {
            XSSimpleTypeDefinition xmlSchemaType = std;
            while (xmlSchemaType != null && (xmlSchemaType.getName() == null || !XSD_INTEGER.equals(BuiltIn.getName((XSTypeDefinition)xmlSchemaType)) && !XSD_NON_NEGATIVE_INTEGER.equals(BuiltIn.getName((XSTypeDefinition)xmlSchemaType)))) {
                xmlSchemaType = xmlSchemaType.getBaseType();
            }
            exiDatatypeID = xmlSchemaType == null ? XSD_DECIMAL : XSD_INTEGER;
        } else {
            exiDatatypeID = BuiltIn.getBuiltInOfPrimitiveMapping(primitive);
        }
        return exiDatatypeID;
    }

    private static Datatype getIntegerDatatype(XSSimpleTypeDefinition std, QName datatypeID) {
        AbstractDatatype datatype;
        XSSimpleTypeDefinition xsdSTD = std;
        while (!"http://www.w3.org/2001/XMLSchema".equals(xsdSTD.getNamespace())) {
            xsdSTD = xsdSTD.getBaseType();
        }
        IntegerType intType = xsdSTD.getName().equals("integer") || xsdSTD.getName().equals("nonPositiveInteger") || xsdSTD.getName().equals("negativeInteger") || xsdSTD.getName().equals("nonNegativeInteger") || xsdSTD.getName().equals("positiveInteger") ? IntegerType.BIG_INTEGER : (xsdSTD.getName().equals("long") || xsdSTD.getName().equals("unsignedLong") || xsdSTD.getName().equals("unsignedInt") ? IntegerType.LONG : IntegerType.INT);
        BigInteger min = new BigInteger("-9999999999999999999999999999999999999999");
        BigInteger max = new BigInteger("9999999999999999999999999999999999999999");
        if (std.isDefinedFacet((short)256)) {
            String sMinInclusive = std.getLexicalFacetValue((short)256);
            min = min.max(new BigInteger(sMinInclusive));
        }
        if (std.isDefinedFacet((short)128)) {
            String sMinExclusive = std.getLexicalFacetValue((short)128);
            min = min.max(new BigInteger(sMinExclusive).add(BigInteger.ONE));
        }
        if (std.isDefinedFacet((short)32)) {
            String sMaxInclusive = std.getLexicalFacetValue((short)32);
            max = max.min(new BigInteger(sMaxInclusive));
        }
        if (std.isDefinedFacet((short)64)) {
            String sMaxExclusive = std.getLexicalFacetValue((short)64);
            max = max.min(new BigInteger(sMaxExclusive).subtract(BigInteger.ONE));
        }
        assert (max.compareTo(min) >= 0);
        BigInteger boundedRange = max.compareTo(BigInteger.ZERO) == -1 ? min.abs().subtract(max.abs()).add(BigInteger.ONE) : (min.compareTo(BigInteger.ZERO) == -1 ? max.add(min.abs()) : max.abs().subtract(min).add(BigInteger.ONE));
        if (boundedRange.compareTo(BigInteger.valueOf(4096L)) <= 0) {
            if (intType == IntegerType.BIG_INTEGER) {
                datatype = new NBitBigIntegerDatatype(datatypeID, min, max, boundedRange.intValue());
            } else if (intType == IntegerType.LONG) {
                datatype = new NBitLongDatatype(datatypeID, min.longValue(), max.longValue(), boundedRange.intValue());
            } else {
                assert (intType == IntegerType.INT);
                datatype = new NBitIntegerDatatype(datatypeID, min.intValue(), max.intValue(), boundedRange.intValue());
            }
        } else if (min.signum() >= 0) {
            if (intType == IntegerType.BIG_INTEGER) {
                datatype = new UnsignedBigIntegerDatatype(datatypeID);
            } else if (intType == IntegerType.LONG) {
                datatype = new UnsignedLongDatatype(datatypeID);
            } else {
                assert (intType == IntegerType.INT);
                datatype = new UnsignedIntegerDatatype(datatypeID);
            }
        } else if (intType == IntegerType.BIG_INTEGER) {
            datatype = new BigIntegerDatatype(datatypeID);
        } else if (intType == IntegerType.LONG) {
            datatype = new LongDatatype(datatypeID);
        } else {
            assert (intType == IntegerType.INT);
            datatype = new IntegerDatatype(datatypeID);
        }
        return datatype;
    }

    private static QName getName(XSTypeDefinition type) {
        return new QName(type.getNamespace(), type.getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Datatype getDatatypeOfType(XSSimpleTypeDefinition std) throws EXIException {
        void var1_23;
        QName schemaDatatype = BuiltIn.getXMLSchemaDatatype(std);
        QName datatypeID = null;
        if (!std.getAnonymous()) {
            datatypeID = new QName(std.getNamespace(), std.getName());
        }
        if (XSD_BASE64BINARY.equals(schemaDatatype)) {
            BinaryBase64Datatype binaryBase64Datatype = new BinaryBase64Datatype(datatypeID);
            return var1_23;
        } else if (XSD_HEXBINARY.equals(schemaDatatype)) {
            BinaryHexDatatype binaryHexDatatype = new BinaryHexDatatype(datatypeID);
            return var1_23;
        } else if (XSD_BOOLEAN.equals(schemaDatatype)) {
            if (std.isDefinedFacet((short)8)) {
                BooleanPatternDatatype booleanPatternDatatype = new BooleanPatternDatatype(datatypeID);
                return var1_23;
            } else {
                BooleanDatatype booleanDatatype = new BooleanDatatype(datatypeID);
            }
            return var1_23;
        } else if (XSD_DATETIME.equals(schemaDatatype)) {
            QName primitive = BuiltIn.getPrimitive(std);
            if (XSD_DATETIME.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.dateTime, datatypeID);
                return var1_23;
            } else if (XSD_TIME.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.time, datatypeID);
                return var1_23;
            } else if (XSD_DATE.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.date, datatypeID);
                return var1_23;
            } else if (XSD_GYEARMONTH.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.gYearMonth, datatypeID);
                return var1_23;
            } else if (XSD_GYEAR.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.gYear, datatypeID);
                return var1_23;
            } else if (XSD_GMONTHDAY.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.gMonthDay, datatypeID);
                return var1_23;
            } else if (XSD_GDAY.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.gDay, datatypeID);
                return var1_23;
            } else {
                if (!XSD_GMONTH.equals(primitive)) throw new RuntimeException();
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DatetimeType.gMonth, datatypeID);
            }
            return var1_23;
        } else if (XSD_DECIMAL.equals(schemaDatatype)) {
            DecimalDatatype decimalDatatype = new DecimalDatatype(datatypeID);
            return var1_23;
        } else if (XSD_FLOAT.equals(schemaDatatype)) {
            FloatDatatype floatDatatype = new FloatDatatype(datatypeID);
            return var1_23;
        } else if (XSD_DOUBLE.equals(schemaDatatype)) {
            DoubleDatatype doubleDatatype = new DoubleDatatype(datatypeID);
            return var1_23;
        } else if (XSD_INTEGER.equals(schemaDatatype)) {
            Datatype datatype = BuiltIn.getIntegerDatatype(std, datatypeID);
            return var1_23;
        } else if (std.isDefinedFacet((short)8)) {
            StringList sl = std.getLexicalPattern();
            if (BuiltIn.isBuiltInTypeFacet(std, sl.getLength())) {
                StringDatatype stringDatatype = new StringDatatype(datatypeID);
                return var1_23;
            } else {
                String regexPattern = sl.item(0);
                EXIRegularExpression re = new EXIRegularExpression(regexPattern);
                if (re.isEntireSetOfXMLCharacters()) {
                    StringDatatype stringDatatype = new StringDatatype(datatypeID);
                    return var1_23;
                } else {
                    CodePointCharacterSet rcs = new CodePointCharacterSet(re.getCodePoints());
                    RestrictedCharacterSetDatatype restrictedCharacterSetDatatype = new RestrictedCharacterSetDatatype(datatypeID, rcs);
                }
            }
            return var1_23;
        } else {
            StringDatatype stringDatatype = new StringDatatype(datatypeID);
        }
        return var1_23;
    }

    private static boolean isBuiltInTypeFacet(XSSimpleTypeDefinition std, int patternListLength) {
        XSSimpleTypeDefinition baseType = (XSSimpleTypeDefinition)std.getBaseType();
        boolean isBuiltInTypeFacet = baseType == null || !baseType.isDefinedFacet((short)8) ? "http://www.w3.org/2001/XMLSchema".equals(std.getNamespace()) : (baseType.getLexicalPattern().getLength() < patternListLength ? "http://www.w3.org/2001/XMLSchema".equals(std.getNamespace()) : BuiltIn.isBuiltInTypeFacet(baseType, patternListLength));
        return isBuiltInTypeFacet;
    }

    private static QName getPrimitive(XSSimpleTypeDefinition std) {
        XSSimpleTypeDefinition primitiveType = std.getPrimitiveType();
        QName primitiveQName = primitiveType == null ? XSD_ANY_SIMPLE_TYPE : new QName(primitiveType.getNamespace(), primitiveType.getName());
        return primitiveQName;
    }

    private static QName getBuiltInOfPrimitiveMapping(QName qnamePrimitive) {
        if (datatypeMapping.containsKey(qnamePrimitive)) {
            return datatypeMapping.get(qnamePrimitive);
        }
        return DEFAULT_VALUE_NAME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IntegerType {
        INT,
        LONG,
        BIG_INTEGER;

    }
}

