/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.EXIDecoderInOrder;
import com.siemens.ct.exi.core.EXIHeader;
import com.siemens.ct.exi.core.container.PreReadValueContainer;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.io.channel.BitDecoderChannel;
import com.siemens.ct.exi.io.channel.ByteDecoderChannel;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.values.Value;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EXIDecoderReordered
extends EXIDecoderInOrder {
    protected List<EventType> eventTypes = new ArrayList<EventType>();
    protected int eventIndex;
    protected List<QNameEntry> qnameEntries = new ArrayList<QNameEntry>();
    protected int qnameEntryIndex;
    protected List<DocTypeEntry> docTypeEntries = new ArrayList<DocTypeEntry>();
    protected int docTypeEntryIndex;
    protected List<String> entityReferences = new ArrayList<String>();
    protected int currentEntityReferenceIndex;
    protected List<char[]> comments = new ArrayList<char[]>();
    protected int commentsIndex;
    protected List<NamespaceEntry> nsEntries = new ArrayList<NamespaceEntry>();
    protected int nsEntryIndex;
    protected List<ProcessingEntry> processingEntries = new ArrayList<ProcessingEntry>();
    protected int processingEntryIndex;
    protected int cntValues;
    protected List<QName> valueQNames = new ArrayList<QName>();
    protected Map<QName, Integer> occurrences = new HashMap<QName, Integer>();
    protected Map<QName, List<Datatype>> dataTypes = new HashMap<QName, List<Datatype>>();
    protected CodingMode codingMode;
    protected Map<QName, PreReadValueContainer> contentValues = new HashMap<QName, PreReadValueContainer>();
    protected List<Value> xsiValues = new ArrayList<Value>();
    protected int xsiValueIndex;
    protected List<String> xsiPrefixes = new ArrayList<String>();
    protected int xsiPrefixIndex;
    protected InputStream resettableInputStream;
    protected InflaterInputStream recentInflaterInputStream;
    protected long bytesRead;
    protected Inflater inflater;
    protected boolean firstChannel;

    public EXIDecoderReordered(EXIFactory exiFactory) {
        super(exiFactory);
        this.codingMode = exiFactory.getCodingMode();
    }

    @Override
    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.nextEvent = null;
        this.nextEventType = EventType.START_DOCUMENT;
        this.eventTypes.clear();
        this.eventIndex = 0;
        this.qnameEntries.clear();
        this.qnameEntryIndex = 0;
        this.docTypeEntries.clear();
        this.docTypeEntryIndex = 0;
        this.entityReferences.clear();
        this.currentEntityReferenceIndex = 0;
        this.comments.clear();
        this.commentsIndex = 0;
        this.nsEntries.clear();
        this.nsEntryIndex = 0;
        this.processingEntries.clear();
        this.processingEntryIndex = 0;
        this.cntValues = 0;
        this.valueQNames.clear();
        this.occurrences.clear();
        this.dataTypes.clear();
        this.contentValues.clear();
        this.xsiValues.clear();
        this.xsiValueIndex = 0;
        this.xsiPrefixes.clear();
        this.xsiPrefixIndex = 0;
        this.preReadStructure();
        this.preReadContent();
    }

    @Override
    public void setInputStream(InputStream is, boolean exiBodyOnly) throws EXIException, IOException {
        this.is = !(is instanceof BufferedInputStream) ? new BufferedInputStream(is) : is;
        if (!exiBodyOnly) {
            BitDecoderChannel headerChannel = new BitDecoderChannel(is);
            EXIHeader.parse(headerChannel);
        }
        this.firstChannel = true;
        this.channel = this.getNextChannel();
        this.initForEachRun();
    }

    public DecoderChannel getNextChannel() throws IOException {
        if (this.codingMode == CodingMode.COMPRESSION) {
            if (this.firstChannel) {
                this.bytesRead = 0L;
                this.resettableInputStream = new BufferedInputStream(this.is);
                this.resettableInputStream.mark(Integer.MAX_VALUE);
                this.inflater = new Inflater(true);
                this.firstChannel = false;
            } else {
                if (!this.inflater.finished()) {
                    while (!this.inflater.finished()) {
                        this.recentInflaterInputStream.read();
                    }
                }
                this.bytesRead += this.inflater.getBytesRead();
                this.resettableInputStream.reset();
                long skipped = this.resettableInputStream.skip(this.bytesRead);
                if (skipped != this.bytesRead) {
                    do {
                        long skippedLoop;
                        if ((skippedLoop = this.resettableInputStream.skip(this.bytesRead - skipped)) <= 0L) {
                            throw new IOException("[EXI] Byte skipping impossible on given input stream");
                        }
                        assert ((skipped += skippedLoop) <= this.bytesRead);
                    } while (skipped < this.bytesRead);
                }
                this.inflater.reset();
            }
            this.recentInflaterInputStream = new InflaterInputStream(this.resettableInputStream, this.inflater);
            return new ByteDecoderChannel(this.recentInflaterInputStream);
        }
        assert (this.codingMode == CodingMode.PRE_COMPRESSION);
        if (this.firstChannel) {
            this.channel = new ByteDecoderChannel(this.is);
            this.firstChannel = false;
        }
        return this.channel;
    }

    protected void preReadStructure() throws EXIException, IOException {
        boolean stillInitializing = true;
        block26: while (stillInitializing) {
            this.eventTypes.add(this.nextEventType);
            switch (this.nextEventType) {
                case START_DOCUMENT: {
                    super.decodeStartDocument();
                    break;
                }
                case START_ELEMENT: {
                    super.decodeStartElement();
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, this.elementPrefix));
                    break;
                }
                case START_ELEMENT_NS: {
                    super.decodeStartElementNS();
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, this.elementPrefix));
                    break;
                }
                case START_ELEMENT_GENERIC: {
                    super.decodeStartElementGeneric();
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, this.elementPrefix));
                    break;
                }
                case START_ELEMENT_GENERIC_UNDECLARED: {
                    super.decodeStartElementGenericUndeclared();
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, this.elementPrefix));
                    break;
                }
                case NAMESPACE_DECLARATION: {
                    super.decodeNamespaceDeclaration();
                    this.nsEntries.add(new NamespaceEntry(this.nsURI, this.nsPrefix));
                    break;
                }
                case ATTRIBUTE_XSI_TYPE: {
                    this.attributePrefix = this.decodeQNamePrefix(xsiTypeQName);
                    this.xsiPrefixes.add(this.attributePrefix);
                    this.decodeAttributeXsiTypeStructure();
                    this.xsiValues.add(this.attributeValue);
                    break;
                }
                case ATTRIBUTE_XSI_NIL: {
                    this.attributePrefix = this.decodeQNamePrefix(xsiNilQName);
                    this.xsiPrefixes.add(this.attributePrefix);
                    this.decodeAttributeXsiNilStructure();
                    this.xsiValues.add(this.attributeValue);
                    break;
                }
                case ATTRIBUTE: {
                    Datatype dtAT = this.decodeAttributeStructure();
                    this.qnameEntries.add(new QNameEntry(this.attributeQName, this.attributePrefix));
                    this.incrementValues(this.attributeQName, dtAT);
                    break;
                }
                case ATTRIBUTE_NS: {
                    Datatype dtAT = this.decodeAttributeNSStructure();
                    this.qnameEntries.add(new QNameEntry(this.attributeQName, this.attributePrefix));
                    this.incrementValues(this.attributeQName, dtAT);
                    break;
                }
                case ATTRIBUTE_INVALID_VALUE: {
                    Datatype dtAT = this.decodeAttributeInvalidValueStructure();
                    this.qnameEntries.add(new QNameEntry(this.attributeQName, this.attributePrefix));
                    this.incrementValues(this.attributeQName, dtAT);
                    break;
                }
                case ATTRIBUTE_ANY_INVALID_VALUE: {
                    Datatype dtAT = this.decodeAttributeAnyInvalidValueStructure();
                    this.qnameEntries.add(new QNameEntry(this.attributeQName, this.attributePrefix));
                    this.incrementValues(this.attributeQName, dtAT);
                    break;
                }
                case ATTRIBUTE_GENERIC: {
                    Datatype dtAT = this.decodeAttributeGenericStructure();
                    this.qnameEntries.add(new QNameEntry(this.attributeQName, this.attributePrefix));
                    this.incrementValues(this.attributeQName, dtAT);
                    break;
                }
                case ATTRIBUTE_GENERIC_UNDECLARED: {
                    Datatype dtAT = this.decodeAttributeGenericUndeclaredStructure();
                    this.qnameEntries.add(new QNameEntry(this.attributeQName, this.attributePrefix));
                    this.incrementValues(this.attributeQName, dtAT);
                    break;
                }
                case CHARACTERS: {
                    this.incrementValues(this.elementContext.qname, this.decodeCharactersStructureOnly());
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, null));
                    break;
                }
                case CHARACTERS_GENERIC: {
                    this.incrementValues(this.elementContext.qname, this.decodeCharactersGenericStructureOnly());
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, null));
                    break;
                }
                case CHARACTERS_GENERIC_UNDECLARED: {
                    this.incrementValues(this.elementContext.qname, this.decodeCharactersGenericUndeclaredStructureOnly());
                    this.qnameEntries.add(new QNameEntry(this.elementContext.qname, null));
                    break;
                }
                case END_ELEMENT: {
                    super.decodeEndElement();
                    this.qnameEntries.add(new QNameEntry(this.elementQName, this.elementPrefix));
                    break;
                }
                case END_ELEMENT_UNDECLARED: {
                    super.decodeEndElementUndeclared();
                    this.qnameEntries.add(new QNameEntry(this.elementQName, this.elementPrefix));
                    break;
                }
                case END_DOCUMENT: {
                    super.decodeEndDocument();
                    stillInitializing = false;
                    continue block26;
                }
                case DOC_TYPE: {
                    super.decodeDocType();
                    this.docTypeEntries.add(new DocTypeEntry(this.docTypeName, this.docTypePublicID, this.docTypeSystemID, this.docTypeText));
                    break;
                }
                case ENTITY_REFERENCE: {
                    super.decodeEntityReference();
                    this.entityReferences.add(this.entityReferenceName);
                    break;
                }
                case COMMENT: {
                    super.decodeComment();
                    this.comments.add(this.comment);
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    super.decodeProcessingInstruction();
                    this.processingEntries.add(new ProcessingEntry(this.piTarget, this.piData));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Event " + (Object)((Object)this.nextEventType));
                }
            }
            this.decodeEventCode();
        }
    }

    protected void preReadContent() throws EXIException {
        try {
            if (this.cntValues <= 100) {
                int i = 0;
                while (i < this.valueQNames.size()) {
                    QName channelContext = this.valueQNames.get(i);
                    int occs = this.occurrences.get(channelContext);
                    List<Datatype> datatypes = this.dataTypes.get(channelContext);
                    this.setContentValues(this.channel, channelContext, occs, datatypes);
                    ++i;
                }
            } else {
                List<Datatype> datatypes;
                if (EXIDecoderReordered.areThereAnyLessEqualThan100(this.valueQNames, this.occurrences)) {
                    DecoderChannel bdcLessEqual100 = this.getNextChannel();
                    int i = 0;
                    while (i < this.valueQNames.size()) {
                        QName channelContext = this.valueQNames.get(i);
                        int occs = this.occurrences.get(channelContext);
                        if (occs <= 100) {
                            datatypes = this.dataTypes.get(channelContext);
                            this.setContentValues(bdcLessEqual100, channelContext, occs, datatypes);
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < this.valueQNames.size()) {
                    QName channelContext = this.valueQNames.get(i);
                    int occs = this.occurrences.get(channelContext);
                    if (occs > 100) {
                        DecoderChannel bdcGreater100 = this.getNextChannel();
                        datatypes = this.dataTypes.get(channelContext);
                        this.setContentValues(bdcGreater100, channelContext, occs, datatypes);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected static boolean areThereAnyLessEqualThan100(List<QName> qnames, Map<QName, Integer> occurrences) {
        int i = 0;
        while (i < qnames.size()) {
            if (occurrences.get(qnames.get(i)) <= 100) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setContentValues(DecoderChannel bdc, QName channelContext, int occs, List<Datatype> datatypes) throws IOException {
        assert (datatypes.size() == occs);
        Value[] decodedValues = new Value[occs];
        int k = 0;
        while (k < occs) {
            Datatype dt = datatypes.get(k);
            decodedValues[k] = this.typeDecoder.readValue(dt, channelContext, bdc);
            ++k;
        }
        this.contentValues.put(channelContext, new PreReadValueContainer(decodedValues));
    }

    @Override
    public boolean hasNext() {
        return this.eventTypes.size() > this.eventIndex + 1;
    }

    @Override
    public EventType next() throws EXIException {
        this.nextEventType = this.eventTypes.get(this.eventIndex++);
        return this.nextEventType;
    }

    protected void incrementValues(QName valueContext, Datatype datatype) {
        ++this.cntValues;
        if (this.valueQNames.contains(valueContext)) {
            this.occurrences.put(valueContext, this.occurrences.get(valueContext) + 1);
        } else {
            this.occurrences.put(valueContext, 1);
            this.dataTypes.put(valueContext, new ArrayList());
            this.valueQNames.add(valueContext);
        }
        this.dataTypes.get(valueContext).add(datatype);
    }

    @Override
    public void decodeStartDocument() {
    }

    @Override
    public void decodeStartElement() {
        QNameEntry se = this.qnameEntries.get(this.qnameEntryIndex++);
        this.elementQName = se.context;
        this.elementPrefix = se.prefix;
    }

    @Override
    public void decodeStartElementNS() {
        this.decodeStartElement();
    }

    @Override
    public void decodeStartElementGeneric() {
        this.decodeStartElement();
    }

    @Override
    public void decodeStartElementGenericUndeclared() {
        this.decodeStartElement();
    }

    @Override
    public void decodeEndElement() throws EXIException {
        QNameEntry ee = this.qnameEntries.get(this.qnameEntryIndex++);
        this.elementQName = ee.context;
    }

    @Override
    public void decodeEndElementUndeclared() throws EXIException {
        this.decodeEndElement();
    }

    @Override
    public void decodeNamespaceDeclaration() throws EXIException {
        NamespaceEntry ns = this.nsEntries.get(this.nsEntryIndex++);
        this.nsURI = ns.namespaceURI;
        this.nsPrefix = ns.prefix;
        this.namespaces.declarePrefix(this.nsPrefix, this.nsURI);
    }

    @Override
    public void decodeAttributeXsiNil() throws EXIException, IOException {
        this.attributeQName = xsiNilQName;
        this.attributePrefix = this.xsiPrefixes.get(this.xsiPrefixIndex++);
        this.attributeValue = this.xsiValues.get(this.xsiValueIndex++);
    }

    @Override
    public void decodeAttributeXsiType() throws EXIException, IOException {
        this.attributeQName = xsiTypeQName;
        this.attributePrefix = this.xsiPrefixes.get(this.xsiPrefixIndex++);
        this.attributeValue = this.xsiValues.get(this.xsiValueIndex++);
    }

    @Override
    public void decodeAttribute() throws EXIException {
        QNameEntry at = this.qnameEntries.get(this.qnameEntryIndex++);
        this.attributeQName = at.context;
        this.attributePrefix = at.prefix;
        PreReadValueContainer vc = this.contentValues.get(this.attributeQName);
        assert (vc != null);
        this.attributeValue = vc.getNextContantValue();
    }

    @Override
    public void decodeAttributeNS() throws EXIException, IOException {
        this.decodeAttribute();
    }

    @Override
    public void decodeAttributeInvalidValue() throws EXIException, IOException {
        this.decodeAttribute();
    }

    @Override
    public void decodeAttributeAnyInvalidValue() throws EXIException, IOException {
        this.decodeAttribute();
    }

    @Override
    public void decodeAttributeGeneric() throws EXIException, IOException {
        this.decodeAttribute();
    }

    @Override
    public void decodeAttributeGenericUndeclared() throws EXIException, IOException {
        this.decodeAttribute();
    }

    @Override
    public void decodeCharacters() throws EXIException {
        QNameEntry ch = this.qnameEntries.get(this.qnameEntryIndex++);
        PreReadValueContainer vc = this.contentValues.get(ch.context);
        assert (vc != null);
        this.characters = vc.getNextContantValue();
    }

    @Override
    public void decodeCharactersGeneric() throws EXIException, IOException {
        this.decodeCharacters();
    }

    @Override
    public void decodeCharactersGenericUndeclared() throws EXIException, IOException {
        this.decodeCharacters();
    }

    @Override
    public void decodeEndDocument() throws EXIException {
    }

    @Override
    public void decodeDocType() throws EXIException {
        DocTypeEntry dt = this.docTypeEntries.get(this.docTypeEntryIndex++);
        this.docTypeName = dt.name;
        this.docTypePublicID = dt.publicID;
        this.docTypeSystemID = dt.systemID;
        this.docTypeText = dt.text;
    }

    @Override
    public void decodeEntityReference() throws EXIException {
        this.entityReferenceName = this.entityReferences.get(this.currentEntityReferenceIndex++);
    }

    @Override
    public void decodeComment() throws EXIException {
        this.comment = this.comments.get(this.commentsIndex++);
    }

    @Override
    public void decodeProcessingInstruction() throws EXIException {
        ProcessingEntry pi = this.processingEntries.get(this.processingEntryIndex++);
        this.piTarget = pi.target;
        this.piData = pi.data;
    }

    static class DocTypeEntry {
        final String name;
        final String publicID;
        final String systemID;
        final String text;

        public DocTypeEntry(String name, String publicID, String systemID, String text) {
            this.name = name;
            this.publicID = publicID;
            this.systemID = systemID;
            this.text = text;
        }
    }

    static class NamespaceEntry {
        final String namespaceURI;
        final String prefix;

        public NamespaceEntry(String namespaceURI, String prefix) {
            this.namespaceURI = namespaceURI;
            this.prefix = prefix;
        }
    }

    static class ProcessingEntry {
        final String target;
        final String data;

        public ProcessingEntry(String target, String data) {
            this.target = target;
            this.data = data;
        }
    }

    static class QNameEntry {
        final QName context;
        final String prefix;

        public QNameEntry(QName context, String prefix) {
            this.context = context;
            this.prefix = prefix;
        }
    }
}

