/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXIEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.BitEncoderChannel;
import com.siemens.ct.exi.io.channel.ByteEncoderChannel;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;

public class EXIEncoderInOrder
extends AbstractEXIEncoder {
    public EXIEncoderInOrder(EXIFactory exiFactory) {
        super(exiFactory);
    }

    public void setOutput(OutputStream os, boolean exiBodyOnly) throws EXIException {
        super.setOutput(os, exiBodyOnly);
        if (this.exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.channel = new BitEncoderChannel(os);
        } else {
            assert (this.exiFactory.getCodingMode() == CodingMode.BYTE_PACKED);
            this.channel = new ByteEncoderChannel(os);
        }
    }

    protected void writeValueTypeValid(QName valueContext) throws IOException {
        this.typeEncoder.writeValue(valueContext, this.channel);
    }

    protected void writeValueAsString(QName valueContext, String value) throws IOException {
        this.typeEncoder.getStringEncoder().writeValue(valueContext, this.channel, value);
    }
}

