#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <wiringPiSPI.h>
#define SPIBUFFSIZE 256
#define CHANNEL 7
#define TERMISTER 10000 // 10k ohm
#define B 3380 // 
#define DIVR 10000 // 10k ohm
unsigned char spidata[SPIBUFFSIZE];
int MCP3008Read( int channel ){
  int spireturn,data;
  spidata[0]= 1; 
  spidata[1]= ( 0x80 | channel << 4 )  ;
  spidata[2]= 0;
  spireturn = wiringPiSPIDataRW( 0, spidata , SPIBUFFSIZE );
  data = ((spidata[1]&3) << 8) + spidata[2];
return(data);
}

int main()
{
  int spiresult;
  double termistor_r,temp,t1,t2,t3,t4;

  if ( -1 ==  wiringPiSPISetup(0,1000000) )
  {
    printf("SPI setup error!");
    exit(1);
  }
  spiresult=MCP3008Read(CHANNEL);
  termistor_r = ( DIVR * (1024-spiresult ))/ (spiresult ); // termistor is upper
//termistor_r = ( DIVR * spiresult )/ (1024 -spiresult );  // termistor is lower
  t1 =   log( termistor_r / TERMISTER ) ;
  temp = ((298*B) / ( B + ( 298 * t1 ))) - 273;
  printf("r: %6.f ohm   temp: %3.f c \n",termistor_r,temp);
}
