// thermocontrol.c
// Licence CC 0 ( Public Domain )
//
// 2 channel thermo control 
// thermocouple0 -> A0 port -> control0 -> D0 port -> heater0
// thermocouple1 -> A1 port -> control1 -> D1 port -> heater1
// termistor -> A7 port ( room temparature )
//
//  control 0: heater is ON up to 500 C , heater is off down to 400 C.
//  control 1: heater is ON up to 500 C , heater is off down to 400 C.
//  
//  Use thermocontroloff program when cut off heater.


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <wiringPi.h>
#include <wiringPiSPI.h>
#define SPIBUFFSIZE 256
#define THERMISTORCHANNEL 7
#define THERMISTOR 10000 // 10k ohm
#define B 3380 // 
#define DIVR 10000 // 10k ohm
unsigned char spidata[SPIBUFFSIZE];
int MCP3008Read( int channel ){
  int spireturn,data;
  spidata[0]= 1; 
  spidata[1]= ( 0x80 | channel << 4 )  ;
  spidata[2]= 0;
  spireturn = wiringPiSPIDataRW( 0, spidata , SPIBUFFSIZE );
  data = ((spidata[1]&3) << 8) + spidata[2];
return(data);
}

int main()
{
  int timecount=0,spiresult,spiresult7,offflag0=0,offflag1=0;
  double thermistor_r,baseTemp,TCTemp0,TCTemp1,t1;
  wiringPiSetup();

  if ( -1 ==  wiringPiSPISetup(0,1000000) )
  {
    printf("SPI setup error!");
    exit(1);
  }

  pinMode(0,OUTPUT);
  pinMode(1,OUTPUT);
  digitalWrite(0,HIGH);
  digitalWrite(1,HIGH);

  while (1){
    spiresult7=MCP3008Read(THERMISTORCHANNEL);
//    thermistor_r = ( DIVR * (1024-spiresult ))/ (spiresult ); // thermistor is upper
    thermistor_r = ( DIVR * spiresult7 )/ (1024 -spiresult7 );  // thermistor is lower
    t1 =   log( thermistor_r / THERMISTOR ) ;
    baseTemp = ((298*B) / ( B + ( 298 * t1 ))) - 273;
  
    spiresult=MCP3008Read(0);
    TCTemp0 = (3.3/1024.0*(double)spiresult*1.010)/0.00407;
    
    spiresult=MCP3008Read(1);
    TCTemp1 = (3.3/1024.0*(double)spiresult*1.010)/0.00407;


    printf("%d :temp: %3.f  %3.f c (room temp: %3.f c )\n",timecount++,TCTemp0+baseTemp,TCTemp1+baseTemp,baseTemp);
    if(TCTemp0+baseTemp>500.0){
      offflag0 = 1;
      digitalWrite(0,LOW);   
    }
    if(TCTemp0+baseTemp<400.0 && 1 == offflag0){
      digitalWrite(0,HIGH);   
    }
    if(TCTemp1+baseTemp>500.0){
      offflag1 = 1;
      digitalWrite(1,LOW);   
    }
    if(TCTemp1+baseTemp<400.0 && 1 == offflag1){
      digitalWrite(1,HIGH);   
    }

    sleep(1);

  }

}
