// thermocouple.c sample program for RaspberryHABU
// Licence CC 0 ( Public Domain )


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <wiringPiSPI.h>
#define SPIBUFFSIZE 256
#define THERMISTORCHANNEL 7
#define THERMISTOR 10000 // 10k ohm
#define B 3380 // 
#define DIVR 10000 // 10k ohm

unsigned char spidata[SPIBUFFSIZE];
int MCP3008Read( int channel ){
  int spireturn,data;
  spidata[0]= 1; 
  spidata[1]= ( 0x80 | channel << 4 )  ;
  spidata[2]= 0;
  spireturn = wiringPiSPIDataRW( 0, spidata , SPIBUFFSIZE );
  data = ((spidata[1]&3) << 8) + spidata[2];
return(data);
}

int main()
{
  int spiresult,spiresult7;
  double thermistor_r,baseTemp,TCTemp0,TCTemp1,t1;
  if ( -1 ==  wiringPiSPISetup(0,1000000) )
  {
    printf("SPI setup error!");
    exit(1);
  }
  while (1){
    spiresult7=MCP3008Read(THERMISTORCHANNEL);
//    thermistor_r = ( DIVR * (1024-spiresult ))/ (spiresult ); // thermistor is upper
    thermistor_r = ( DIVR * spiresult7 )/ (1024 -spiresult7 );  // thermistor is lower
    t1 =   log( thermistor_r / THERMISTOR ) ;
    baseTemp = ((298*B) / ( B + ( 298 * t1 ))) - 273;
  
    spiresult=MCP3008Read(0);
    TCTemp0 = (3.3/1024.0*(double)spiresult*1.010)/0.00407;
    spiresult=MCP3008Read(1);
    TCTemp1 = (3.3/1024.0*(double)spiresult*1.010)/0.00407;

    printf("temp: %3.f  %3.f c  (room temp: %3.f c : A0 value0 %d)\n",TCTemp0+baseTemp,TCTemp1+baseTemp,baseTemp,spiresult);
    sleep(1);
  }

}
