#!/bin/busybox sh
ssTimer=60  # screen shot timer
pid=$(pidof nickel)
if [ -z "$pid" ] ; then
  nickelState=T
else
  nickelState=$(awk '$1=="State:"{print $2; exit;}' /proc/$pid/status)
fi
/root/bin/StopNickel.sh
wnk=$(mktemp /tmp/wnk_XXXXXX)
printf '5 8 0 8\n45 0 8 0\n' > $wnk
$FKSH_HOM/tools/whinker.sh $wnk
$FKSH_HOM/tools/dontNap.sh ON $$
onEXIT () {
  sync; sync
  /root/bin/ContNickel.sh
  rm -f $wnk
  $FKSH_HOM/tools/dontNap.sh OFF $$ 20
}
(
# run background
trap onEXIT EXIT
## close almost file descripters
for fdp in /proc/$$/fd/* ; do
  [ -e "$fdp" -o -L "$fdp" ] || continue
  fd=${fdp##*/}
  case "$fd" in
  0|1|2 ) ;;
  *) eval "exec $fd<&- $fd>&-" ;;
  esac
done
tries=120
until [ -d "$FKSH_ONB" ] ; do
  [ tries -le 0 ] && exit
  tries=$(($tries - 1))
  usleep 100000
done
dotKobo="/mnt/onboard/.kobo"
if [ -f "$dotKobo/KoboRoot.tgz" -o -f "$dotKobo/Kobo.tgz" ] ; then
  exit 0
fi
tries=30
if [ -b /dev/mmcblk1p1 ] ; then
  while : ; do
    grep -q '^/dev/mmcblk1p1' /proc/mounts && break
    [ $tries -le 0 ] && break
    tries=$(($tries - 1))
    usleep 100000
  done
fi
if which sqlite3 ; then
  sqlOut=$FKSH_ONB/db
  [ -d $sqlOut ] || mkdir $sqlOut
  sqlOut=$sqlOut/autoUpdate.sql
  db=/mnt/onboard/.kobo/KoboReader.sqlite
  $FKSH_HOM/tools/autoUpdateSQL.sh > $sqlOut
  errOut=/mnt/onboard/autoUpdateSQL.err
  sqlite3 $db < $sqlOut 2> $errOut || sqlite3 $db < $sqlOut 2> $errOut
  [ -s $errOut ] || rm -f $errOut
fi
$FKSH_HOM/tools/config.sh &

# capture screen for sleep and poweroff
cd "$FKSH_ONB" || exit 0
export PATH="/root/bin:${PATH}"
for seq in sleep.seq poweroff.seq passwd.seq *.seq ; do
  [ -f $seq ] || continue
  while read -r i dum ; do
    case "$i" in
    *.raw.gz) ;;
    *) continue ;;
    esac
    case "$i" in
    /* | ./* ) h="${i%.raw.gz}" ;;
    *) h="./images/${i%.raw.gz}" ;;
    esac
    case "$h" in
    *.BW | *.WB )
      h="${h%.*}"
      [ -f "$h".BW.raw.gz -a -f "$h".WB.raw.gz ] && continue
      [ -f "$h".WB.raw.gz.wait ] && continue
      if [ -f "$h".raw.gz -o -f "$h".raw.gz.wait ] ; then
        {
          until [ -f "$h".raw.gz ] ; do sleep 1; done
          screenShot-raw1.sh "$h" conv < "$h".raw.gz
        } &
        continue
      else
        screenShot-raw.sh "$h" $ssTimer wait
        usleep 1000
        screenShot-raw1.sh "$h" conv wait < "$h".raw.gz
        exit 0
      fi
    ;;
    *.raw.gz)
      [ -f "$h".raw.gz -o -f "$h".raw.gz.wait ] && continue
      screenShot-raw.sh "$h" $ssTimer wait
      exit 0
    ;;
    esac
  done < $seq
done &
) >/dev/null 2>&1 </dev/null &

exit 0
