#!/bin/busybox sh
cd /
(
envFile=$FKSH_RAM/nickelENV.sh
[ -f $envFile ] || exit 0
case "$1" in
[0-9] | [1-9][0-9] ) n=$1 ;;
*) n=1 ;;
esac
excl=$FKSH_RAM/private/respawnNickel ## for exclusive
rspwnN=$FKSH_RAM/private/rspwnN ## count
until ln -s $$ $rspwnN.x ; do usleep 1000 ; done
if ln -s $$ $excl ; then
  echo $n > $rspwnN
  rm -f $rspwnN.x
else
  read k < $rspwnN
  echo $((n+k)) > $rspwnN
  rm -f $rspwnN.x
  exit 0
fi
. $envFile
## close almost file descripters
for fdp in /proc/$$/fd/* ; do
  [ -e "$fdp" -o -L "$fdp" ] || continue
  fd=${fdp##*/}
  case "$fd" in
  0|1|2 ) ;;
  *) eval "exec $fd<&- $fd>&-" ;;
  esac
done
sleep 1
while [ $n -gt 0 ] ; do
  lastPid=''
  for pid in $(pidof nickel) ; do
    [ -z "$lastPid" ] || kill -i $lastPid
    lastPid=$pid
  done
  if [ -e /mnt/onboard/.kobo/KoboRoot.tgz ] ; then
    # the case "/etc/init.d/update-animator.sh" in /usr/local/Kobo/udev/usb
    rm -f $envFile
    exit 0  # it will reboot!
  fi
  if ! pidof nickel ; then
    (
      /usr/local/Kobo/nickel -qws >/dev/console 2>&1 </dev/null &
    )
    [ -f $FKSH_LOG ] &&
      printf '%s #DEAD_NICKEL\n' $(/root/bin/hwtime.sh) >> $FKSH_LOG
  fi
  sleep 13
  until ln -s $$ $rspwnN.x ; do usleep 1618 ; done
  read n < $rspwnN
  n=$((n-1))
  echo $n > $rspwnN
  rm -f $rspwnN.x
done
rm -f $excl
exit 0
) >/dev/null 2>&1 </dev/null &
exit 0
