#!/bin/busybox sh
export FKSH_HOM=$(readlink -f "${0%/*}")
export FKSH_ONB=/mnt/onboard/.fakesh
export FKSH_LOG=/var/tmp/fakesh.log
#
export FKSH_RAM=$FKSH_HOM/ram
eval $(date '+TZMIN=$(((%k*60+36%M-%s/60%%1440)%%1440-720))')
real_sh=$FKSH_HOM/sh
executor=$FKSH_HOM/fakesh.pretender

cd /

install_skel() {
  if [ ! -d $FKSH_ONB ] ; then
    rm -rf $FKSH_ONB
    cp -a $FKSH_HOM/skel.fakesh $FKSH_ONB
  fi
  $FKSH_HOM/tools/genSimpPics.sh
  if [ ! -f $FKSH_ONB/.saved.tgz ] ; then
    saved_files='/etc/passwd /etc/hosts'
    if [ -f /etc/shells ] ; then
      saved_files="$saved_files /etc/shells"
    else
      # why no /etc/shells?
      cat <<- 'EOshells'
	# /etc/shells: valid login shells
	/bin/sh
	/bin/ash
	#/bin/dash
	#/bin/zsh
	#/usr/bin/zsh
	#/bin/ksh
	#/usr/bin/ksh
	#/usr/bin/rc
	#/bin/bash
	#/usr/tcsh
	#/usr/bin/tcsh
	EOshells
    fi
    tar cfz $FKSH_ONB/.saved.tgz $saved_files
  fi
  if [ -f $FKSH_ONB/keeps.tgz ] ; then
    tar xfz $FKSH_ONB/keeps.tgz -C /
  elif [ -f /home/keeps.tgz ] ; then
    tar xfz /home/keeps.tgz -C /
  else
    f='[^:]*:'
    sed -i "/^root:/s@^\($f$f$f$f$f\).*@\1/root:/bin/ash@" /etc/passwd
    grep -q 'google-analytics' /etc/hosts || cat >> /etc/hosts <<- EOhosts
	127.0.0.1 www.google-analytics.com ssl.google-analytics.com
	127.0.0.1 www-google-analytics.l.google.com
	EOhosts
  fi
}

uninstall0 () {
  rm -rf $FKSH_ONB/keeps.tgz
  tar cfz $FKSH_ONB/keeps.tgz /etc/passwd /etc/hosts /etc/shells
  if [ -d /home ] ; then
    # against factory reset
    rm -rf /home/keeps.tgz
    cp -a $FKSH_ONB/keeps.tgz /home/keeps.tgz
  fi
  if [ -f $FKSH_ONB/.saved.tgz ] ; then
    tar xfz $FKSH_ONB/.saved.tgz -C /
    rm -rf $FKSH_ONB/.saved.tgz
  fi
  ## TODO clean /root/bin/* ... and /etc/fakesh
}

# install common
setup_common () {
  if [ ! -f $real_sh ] ; then
    rm -rf $real_sh
    # hard link, must be in the same partion.
    ln /bin/busybox $real_sh || exit 1 
  fi
  if [ ! -d $FKSH_RAM ] ; then
    rm -rf $FKSH_RAM
    mkdir -m 000 $FKSH_RAM
    chattr +i $FKSH_RAM
  fi
  blkid | grep '^/dev/mmcblk0p' > $FKSH_HOM/blkid.0p
  [ -f $FKSH_HOM/.initwait ] || echo 200000 > $FKSH_HOM/.initwait
  # cleaning mount points
  mtpt=$(mktemp -d /tmp/root_XXXXXX)
  mount --bind / $mtpt
  for pp in /proc /sys /mnt/onboard /mnt/sd ; do
    # dont include /tmp /dev /var/*, $FKSH_RAM is done in "setup-fakesh.sh"
    p=$mtpt$pp
    [ -d $p ] || continue
    rm -rf $p/.[!.] $p/.??* $p/*
    chmod 000 $p
    chattr +i $p
  done >/dev/null 2>&1
  p=$mtpt/tmp
  chmod 1777 $p
  rm -rf $p/.[!.] $p/.??* $p/*
  while read mj mi sz nam ; do
    [ -b $mtpt/dev/$nam ] && continue
    case "$nam" in
    mmcblk0*) mknod -m 660 $mtpt/dev/$nam b $mj $mi ;;
    esac
  done < /proc/partitions
  umount $mtpt
  rm -rf $mtpt
  if [ ! -e /.mac-address ] ; then
    ## against a bug nickel ?
    touch /.mac-address
    chmod 000 /.mac-address
    chattr +i /.mac-address
  fi
}

# install Stand Alone TYPE fakesh
setup_SA () {
  local tgt
  tgt=$FKSH_HOM/fakesh.SA
  rm -rf $tgt
  awk -v sw=$FKSH_HOM/fakesh.switches \
    -v FKSH_ONB=$FKSH_ONB \
    -v FKSH_HOM=$FKSH_HOM \
    -v FKSH_LOG=$FKSH_LOG \
    -v TZMIN=$TZMIN \
    -v EXIT='exit ' \
    -v real_sh=$real_sh '{
      sub("@FKSH_ONB@", FKSH_ONB);
      sub("@FKSH_HOM@", FKSH_HOM);
      sub("@FKSH_LOG@", FKSH_LOG);
      sub("@TZMIN@", TZMIN);
      sub("@real_sh@", real_sh);
    }
    /## hook switches/{
      while (getline <sw) {
        sub("@EXIT@", EXIT);
        if ( $0 != "" ) { printf "  %s\n", $0;}
      }
      next;
    }
    /^##/{next;}
    {print;}' $tgt.in $executor > $tgt || return 2
  /bin/busybox sh -n $tgt || return 3 # check syntax
  #  
  chmod 755 $tgt
## consider timing ...
##kill the other DAEMON
#
  ln -f $tgt /bin/sh
}

setup_hwtime_sh () {
  local tgt
  tgt=$FKSH_HOM/hwtime.sh
  rm -rf $tgt
  sed "s/@TZMIN@/$(printf %+d $TZMIN)/g" $tgt.in > $tgt || return 2
  chmod 755 $tgt
  rm -rf /root/bin/hwtime.sh
  mv $tgt /root/bin/hwtime.sh
}

##--------

fakesh_type=SA

install_skel
setup_common
case "$fakesh_type" in
SA) setup_SA ;;
esac
setup_hwtime_sh

[ -f $FKSH_RAM/BOOT ] || $FKSH_HOM/init.sh "$fakesh_type"

exit 0

