package fs.game.reversi.game;

import android.os.Handler;
import fs.game.reversi.Global;
import fs.game.reversi.game.ReversiBoard.MoveAction;

public class ActionDispatcher {
	Handler uithread = new Handler();

	public void dispatch(MoveAction action) {
		uithread.post(new ActionAdapter(action));
		// remote.post(new RemoteActionAdapter(action));
	}

	static class ActionAdapter implements Runnable {
		private MoveAction action;

		public ActionAdapter(MoveAction action) {
			this.action = action;
		}

		@Override
		public void run() {
			synchronized (action) {
				action.consume();

				Global.mainActivity.dispatchMoveEvent(action);

				// Playerスレッドを復活させる
				action.notifyAll();
			}
		}
	}
}
