package fs.game.reversi.game;

import fs.game.core.Actor;
import fs.game.reversi.Global;
import fs.game.reversi.game.ReversiBoard.MoveAction;

public abstract class Player implements Actor<ReversiBoard> {

	private boolean over;

	private int moveX;
	private int moveY;

	private boolean white;

	public Player(boolean white) {
		this.white = white;
	}

	@Override
	public void set(ReversiBoard table) {
	}

	@Override
	public void ready() {
	}

	@Override
	public void process() {
		while (!over) {
			synchronized (this) {
				// 外部（UI or 通信）スレッドを待つ
				notifyAll();
				wait(this);

				if (!move()) {
					continue;
				} else {
					// とりあえず
					Global.switchUser();
				}
			}

			synchronized (Global.board) {
				// 他プレイヤーの入力を待つ
				Global.board.notifyAll();
				wait(Global.board);
			}
		}
	}

	@Override
	public void interrupt() {
	}

	@Override
	public void over() {
		over = true;
	}

	/**
	 * moveX, moveYをboardに反映。
	 * 
	 * @return 置けない場合はfalse
	 */
	protected boolean move() {
		MoveAction action = Global.board.move(moveX, moveY, white);

		if (action.isValid()) {
			synchronized (action) {
				Global.actionDispatcher.dispatch(action);

				// UIを待機
				wait(action);
			}
		}

		return action.isValid();
	}

	/**
	 * 外部（UI or 通信）イベント受付。
	 * 
	 * @param x 横位置
	 * @param y 縦位置
	 */
	public synchronized void move(int x, int y) {
		moveX = x;
		moveY = y;
		notifyAll();
	}

	private void wait(Object obj) {
		try {
			obj.wait();
		} catch (InterruptedException e) {
		}
	}

	// TODO UI用Player/通信用Playerを作ったら消す
	public static class PlayerStub extends Player {

		public PlayerStub(boolean white) {
			super(white);
		}
	}
}
