/**
 *
 */
package fs.game.reversi.sound;

import android.content.Context;
import android.media.MediaPlayer;

/**
 * @author noguchi
 *
 */
public class BGMManager {
	private Context context = null;
	private MediaPlayer mediaPlayer = null;

	private float leftVolume = 1.0f;
	private float rightVolume = 1.0f;

	public BGMManager(Context context){
		this.context = context;
	}

	public BGMManager(Context context, int resourceID ){
		this.context = context;
		this.mediaPlayer = MediaPlayer.create(context, resourceID);
		this.mediaPlayer.setLooping(true);
		this.mediaPlayer.setVolume(leftVolume, rightVolume);
	}

	public BGMManager(Context context, int resourceID, boolean looping ){
		this.context = context;
		this.mediaPlayer = MediaPlayer.create(context, resourceID);
		this.mediaPlayer.setLooping(looping);
		this.mediaPlayer.setVolume(leftVolume, rightVolume);
	}

	public BGMManager(Context context, int resourceID, boolean looping, float leftVolume, float rightVolume ){
		this.context = context;
		this.mediaPlayer = MediaPlayer.create(context, resourceID);
		this.mediaPlayer.setLooping(looping);
		this.mediaPlayer.setVolume(leftVolume, rightVolume);

		this.leftVolume = leftVolume;
		this.rightVolume = rightVolume;
	}

	public boolean loadBGM(int resourceID){
		boolean result = false;

		if( mediaPlayer == null ){
			mediaPlayer = MediaPlayer.create(context, resourceID);
			mediaPlayer.setLooping(true);
			mediaPlayer.setVolume(leftVolume, rightVolume);

			result = true;
		}
		return result;
	}

	/**
	 * BGMを再生する
	 */
	public void start(){
		if( !mediaPlayer.isPlaying() ){
			mediaPlayer.seekTo(0);
			mediaPlayer.start();
		}
	}

	/**
	 * BGMを停止する
	 */
	public void stop(){
		if( mediaPlayer.isPlaying() ){
			mediaPlayer.stop();
			mediaPlayer.prepareAsync();
		}
	}

	/**
	 * 左側のボリュームを取得できます
	 *
	 * @return leftVolume
	 */
	public float getLeftVolume() {
		return leftVolume;
	}

	/**
	 * 左側のボリュームを設定できます
	 *
	 * @param leftVolume セットする leftVolume
	 */
	public void setLeftVolume(float leftVolume) {
		this.leftVolume = leftVolume;
	}

	/**
	 * 右側のボリュームを取得できます
	 *
	 * @return rightVolume
	 */
	public float getRightVolume() {
		return rightVolume;
	}

	/**
	 * 右側のボリュームを設定できます
	 *
	 * @param rightVolume セットする rightVolume
	 */
	public void setRightVolume(float rightVolume) {
		this.rightVolume = rightVolume;
	}



}
