/**
 *
 */
package fs.game.reversi.sound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.content.Context;

/**
 * @author noguchi
 *
 */
public class SoundManager {
	private static SoundManager instance = null;

	private Context context = null;

	private Map<String, BGMManager> bgmMap = new HashMap<String, BGMManager>();
	private SEManager seManager = null;

	/**
	 * コンストラクタ
	 *
	 * @param context
	 */
	private SoundManager(Context context) {
		this.context = context;

		seManager = new SEManager(context);
	}

	public BGMManager getBGM(String key) {
		synchronized (this) {
			BGMManager bgmMng = null;

			if (bgmMap.containsKey(key)) {
				bgmMng = bgmMap.get(key);
			} else {
				bgmMng = new BGMManager(context);

				bgmMap.put(key, bgmMng);
			}
			return bgmMng;
		}
	}

	/**
	 * すべてのBGMを停止する
	 */
	public void stopBGMAll() {
		if (bgmMap != null && bgmMap.size() > 0) {
			synchronized (this) {
				List<String> keys = new ArrayList<String>(bgmMap.keySet());

				for(String key : keys ){
					BGMManager bgmMng = bgmMap.get(key);
					bgmMng.stop();
				}
			}
		}
	}

	/**
	 * Sound Effect Managerを取得する
	 *
	 * @return
	 */
	public SEManager getSEManager()
	{
		return seManager;
	}

	/**
	 * FSSoundManagerのインスタンスを返します
	 *
	 * @param context
	 * @return
	 */
	public static SoundManager getInstance(Context context) {
		if (instance == null) {
			instance = new SoundManager(context);
		}
		return instance;
	}
}
