/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace FooEditEngine
{
    /// <summary>
    /// IMarkerPatternC^[tFCX
    /// </summary>
    public interface IMarkerPattern
    {
        /// <summary>
        /// }[J[Ԃ
        /// </summary>
        /// <param name="lineHeadIndex">sւ̃CfbNX\</param>
        /// <param name="s"></param>
        /// <returns>Marker񋓑̂Ԃ</returns>
        IEnumerable<Marker> GetMarker(int lineHeadIndex, string s);
    }
    /// <summary>
    /// K\Ń}[J[̎擾sNX
    /// </summary>
    public sealed class RegexMarkerPattern : IMarkerPattern
    {
        Regex regex;
        HilightType type;
        Color color;
        /// <summary>
        /// RXgN^[
        /// </summary>
        /// <param name="regex">regexIuWFNg</param>
        /// <param name="type">nCCg^Cv</param>
        /// <param name="color">F</param>
        public RegexMarkerPattern(Regex regex,HilightType type,Color color)
        {
            this.regex = regex;
            this.type = type;
            this.color = color;
        }

        /// <summary>
        /// }[J[Ԃ
        /// </summary>
        /// <param name="lineHeadIndex">sւ̃CfbNX\</param>
        /// <param name="s"></param>
        /// <returns>Marker񋓑̂Ԃ</returns>
        public IEnumerable<Marker> GetMarker(int lineHeadIndex, string s)
        {
            foreach (Match m in this.regex.Matches(s))
            {
                yield return Marker.Create(lineHeadIndex + m.Index, m.Length, this.type,this.color);
            }
        }
    }
    /// <summary>
    /// MarkerPatternZbg
    /// </summary>
    public sealed class MarkerPatternSet
    {
        MarkerCollection markers;
        Dictionary<int, IMarkerPattern> set = new Dictionary<int, IMarkerPattern>();

        internal MarkerPatternSet(LineToIndexTable lti,MarkerCollection markers)
        {
            lti.CreateingLayout += lti_CreateingLayout;
            this.markers = markers;
        }

        void lti_CreateingLayout(object sender, CreateLayoutEventArgs e)
        {
            LineToIndexTable lti = (LineToIndexTable)sender;
            foreach (int id in this.set.Keys)
            {
                this.markers.RemoveAll(id, e.Index, e.Length);
                this.markers.AddRange(id, this.set[id].GetMarker(e.Index,e.Content));
            }
        }

        internal event EventHandler Updated;

        /// <summary>
        /// WatchDogǉ
        /// </summary>
        /// <param name="id">}[J[ID</param>
        /// <param name="dog">IMarkerPatternC^[tFCX</param>
        public void Add(int id, IMarkerPattern dog)
        {
            this.set.Add(id, dog);
            this.Updated(this, null);
        }

        /// <summary>
        /// }[J[ID܂܂Ă邩ǂ𒲂ׂ
        /// </summary>
        /// <param name="id">}[J[ID</param>
        /// <returns>܂܂Ăΐ^BłȂ΋U</returns>
        public bool Contains(int id)
        {
            return this.set.ContainsKey(id);
        }

        /// <summary>
        /// WatchDogǉ
        /// </summary>
        /// <param name="id">}[J[ID</param>
        public void Remove(int id)
        {
            this.markers.Clear(id);
            this.set.Remove(id);
            this.Updated(this, null);
        }
    }
}