﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;

namespace FooEditEngine
{
    enum GripperPostion
    {
        Upper,
        Bottom,
    }
    class Gripper : IEquatable<Gripper>
    {
        public const int GripperWidth = 20;
        public const int HitAreaWidth = 48;

        Controller Controller;
        EditView View;
        D2DRender Render;
        GripperPostion type;
        public Gripper(Controller controller, EditView view,D2DRender render,GripperPostion type)
        {
            this.Controller = controller;
            this.View = view;
            this.Render = render;
            this.Enabled = false;
            this.type = type;
        }
        public bool Enabled
        {
            get;
            set;
        }
        public Rectangle Rectangle
        {
            get
            {
                return this.GetGripperRect(this.type, GripperWidth, GripperWidth);
            }
        }
        public bool IsHit(Point p)
        {
            Rectangle gripperRect = this.GetGripperRect(type, HitAreaWidth, HitAreaWidth);
            return this.Enabled && gripperRect.IsHit(p);
        }

        public Point AdjustPoint(Point p)
        {
            if (this.type == GripperPostion.Upper)
            {
                if (this.Rectangle.IsHit(p))
                    p.Y = this.Rectangle.Bottom + 1;
                else
                    p.Y += this.Rectangle.Height;
            }
            else
            {
                if (this.Rectangle.IsHit(p))
                    p.Y = this.Rectangle.Y - 1;
                else
                    p.Y -= this.Rectangle.Height;
            }
            if (p.Y < this.Render.TextArea.Y)
                p.Y = this.Render.TextArea.Y;
            return p;
        }

        public void Draw()
        {
            if(this.Enabled)
                this.DrawGripper(this.type);
        }

        void DrawGripper(GripperPostion type)
        {
            Rectangle gripperRect = GetGripperRect(type,GripperWidth,GripperWidth);
            double radius = gripperRect.Width / 2;
            Point point;
            point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            this.Render.DrawGripper(point, radius);
        }

        Rectangle GetGripperRect(GripperPostion type,int width,int height)
        {
            TextPoint tp;
            Point point;
            double radius = width / 2;
            if (type == GripperPostion.Bottom)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart + this.Controller.SelectionLength);
                point = this.View.GetPostionFromTextPoint(tp);
                double lineHeight = this.View.LayoutLines.GetLayout(tp.row).Height;
                return new Rectangle(point.X - radius, point.Y + lineHeight, width, height);
            }
            else if (type == GripperPostion.Upper)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart);
                point = this.View.GetPostionFromTextPoint(tp);
                return new Rectangle(point.X - radius, point.Y - height, width, height);
            }
            else
            {
                throw new ArgumentOutOfRangeException();
            }
        }

        public bool Equals(Gripper other)
        {
            return this.Rectangle == other.Rectangle;
        }
    }
}
