﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.core.geometry;
using System.Drawing;

namespace nft.core.geometry {
    public class GeometricConstants {
        public static readonly Vect3D SunLight = Vect3D.CreateUnitVector(0.9, 0.5, -1.4);
        public static readonly Vect3D CameraEye = Vect3D.CreateUnitVector(1, 1, -1);
        public const int UnitWidthPixel = 16;
        public const int UnitHeightPixel = 2;
        public const int HalfOf_UnitWidthPixel = UnitWidthPixel>>1;
        public const int QuaterOf_UnitWidthPixel = UnitWidthPixel>>2;
        public const double EnvironmentLight = 0.25;
        public const int TerrainStepHeightInUnit = 2;
        public const int TerrainMaxHeightInUnit = 8;
        public const int TerrainStepHeightInPixel = UnitHeightPixel * TerrainStepHeightInUnit;
        public const int TerrainMaxHeightInPixel = UnitHeightPixel * TerrainMaxHeightInUnit;
    }
}
