﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace nft.framework.drawing {
    class GDIDrawer {
        private static Point[] arrPts;
        static readonly Point[] edgeOffsets = new Point[] { new Point(0, 0), new Point(0, 1),
            new Point(0, 2), new Point(1, 0), new Point(1, 2), new Point(2, 0), new Point(2, 1), new Point(2, 2)};
        static GDIDrawer() {
            arrPts = new Point[6];
            for (int i = 0; i < arrPts.Length; i++) {
                arrPts[i] = new Point();
            }
        }

        public static void DrawEdgedText(Graphics g, string txt, Font f, Point p, Color fore, Color edge) {
            using(Brush br = new SolidBrush(edge)){
                Point p2 = new Point();
                foreach (Point off in edgeOffsets) {
                    p2.X = p.X + off.X;
                    p2.Y = p.Y + off.Y;
                    g.DrawString(txt, f, br, p2);
                }
            }
            using (Brush br = new SolidBrush(fore)) {
                Point p2 = new Point(p.X + 1, p.Y+1);
                g.DrawString(txt, f, br, p2);
            }
        }

        public static SizeF GetEdgedTextSize(Graphics g, string txt, Font f) {
            return g.MeasureString(txt, f);
        }



        public static void FillCellBounds(Graphics g, Color c, QuaterViewRect rect) {
            Point[] pt = arrPts;
            rect.GetVertices(ref pt);
            using (Brush br = new SolidBrush(c)) {
                g.FillPolygon(br,pt);
            }
        }

        public static void DrawCellBounds(Graphics g, Color edge, QuaterViewRect rect) {
            DrawCellBounds(g, edge, rect, 1);
        }

        public static void DrawCellBounds(Graphics g, Color edge, QuaterViewRect rect, int width) {
            Point[] pt = arrPts;
            rect.GetVertices(ref pt);
            using (GraphicsPath path = new GraphicsPath()) {
                path.AddPolygon(pt);
                path.CloseFigure();
                int ox = 0, oy = width, wh = width, wl = width, wr = width;
                using (Region rgn1 = new Region(path)) {
                    int h = rect.Height - width;
                    if (h < 0) {
                        wh = rect.Height;
                        wl -= h;
                        wr -= h;
                    }
                    if (rect.LWidth < width) {
                        wl = -rect.LWidth;
                        ox += width;
                        wr += width;
                        oy += width >> 1;
                        wh += width;
                    }
                    if (rect.RWidth < width) {
                        wr = -rect.RWidth;
                        ox -= width;
                        wl += width;
                        oy += width >> 1;
                        wh += width;
                    }
                    QuaterViewRect r2 = new QuaterViewRect(rect.X + ox, rect.Y - oy,
                       rect.LWidth - wl, rect.RWidth - wr, rect.Height - wh);
                    r2.GetVertices(ref pt);
                    using (GraphicsPath path2 = new GraphicsPath()) {
                        path2.AddPolygon(pt);
                        path2.CloseFigure();
                        
                        using (Region rgn2 = new Region(path2)) {
                            rgn1.Xor(rgn2);
                            using (Brush br = new SolidBrush(edge)) {
                                g.FillRegion(br, rgn1);
                            }
                        }
                        
                    }
                }
            }
        }

        public static void FillPolygon(Graphics g, Color c, Point[] vrtics, Point offset) {
            using (Brush br = new SolidBrush(c)) {
                g.TranslateTransform(-offset.X, -offset.Y);
                g.FillPolygon(br, vrtics);
                g.TranslateTransform(offset.X, offset.Y);
            }
        }
    }
}
