using System;
using System.Drawing;

namespace nft.framework.drawing
{
	/// <summary>
	/// IDrawable ISurfaceɕ`\ȃIuWFNg
	/// </summary>
	public interface IDrawable : IDisposable
	{
		/*
        /// <summary>
		/// T[tFXɕ`
		/// </summary>
		/// <param name="dest">`̃T[tFX</param>
		/// <param name="location">`̈ʒuij</param>
		/// <param name="frame">t[ԍiAj[Vpj</param>
		void Draw(ISurface dest, Point location, Scaler scale, int frame );
        void DrawEx(ISurface dest, Point location, Scaler scale, IPixelFilter filter, int frame);
        void DrawEx(ISurface dest, Point location, Scaler scale, ISurfaceDrawer drawer, int frame);
        */
        void Draw(DrawParams param);
        void DrawEx(DrawParams param, IPixelFilter filter);
        void DrawEx(DrawParams param, ISurfaceDrawer drawer);
	}

    public enum ClipUsage : int { Ignore = 0, Source, Destination }

    public class DrawParams {        
        /// <summary>
        /// `̃T[tFX
        /// </summary>
        public ISurfaceOld Destination;
        /// <summary>
        /// `̈ʒuij
        /// </summary>
        public Point Location;
        /// <summary>
        /// NbsO`̈
        /// </summary>
        public Rectangle SoruceClip = Rectangle.Empty;
        /// <summary>
        /// NbsO`̈
        /// </summary>
        public Rectangle DestinationClip;
        /// <summary>
        /// `{
        /// </summary>
        public Scaler Scaler;
        /// <summary>
        /// t[idefault=0j
        /// </summary>
        public int FrameNo = 0;

        public DrawParams(ISurfaceOld dest, Point location) {
            this.Destination = dest;
            this.DestinationClip = new Rectangle(new Point(),dest.Size);
            this.Location = location;
            this.Scaler = Scaler.Default;
        }

        public DrawParams(ISurfaceOld dest, Point location, Scaler scaler) {
            this.Destination = dest;
            this.DestinationClip = new Rectangle(new Point(), dest.Size);
            this.Location = location;
            this.Scaler = scaler;
        }

        public DrawParams(ISurfaceOld dest, Point location, Scaler scaler, int frame) {
            this.Destination = dest;
            this.DestinationClip = new Rectangle(new Point(), dest.Size);
            this.Location = location;
            this.Scaler = scaler;
            this.FrameNo = frame;
        }

        public void ClearClip() {
            DestinationClip = new Rectangle(new Point(), Destination.Size);
            SoruceClip = Rectangle.Empty;
        }

        public DrawParams Clone() {
            DrawParams dp = MemberwiseClone() as DrawParams;
            return dp;
        }
    }
}
