using System;
using System.Xml;
using nft.util;
using System.Diagnostics;

namespace nft.framework.plugin {
    /// <summary>
    /// Instantiate a Contribution class by custom method (maybe according to the description of XML element)
    /// The Contribution should be an instance of specified baseType.
    /// <seealso cref="CtbCustomCtbFactory"/>
    /// </summary>
    [Obsolete]
    public abstract class CustomContributionFactory : IContributionFactory {
        protected CustomContributionFactory(Type basetype) {
            this.baseType = basetype;
        }

        public CustomContributionFactory(XmlElement e)
            : this(PluginUtil.loadTypeFromManifest(
                (XmlElement)XmlUtil.SelectSingleNode(e, "basetype"))) { }


        private readonly Type baseType;
        public Type OutputType { get { return baseType; } }

        public Contribution load(Plugin owner, XmlElement e) {
            Contribution contrib = Cretate(owner, e);
            Debug.Assert(baseType.IsInstanceOfType(contrib));
            return contrib;
        }

        protected abstract Contribution Cretate(Plugin owner, XmlElement e);
    }
}
