﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.core.geometry;

namespace nft.impl.game {
    class OccupationMaskLibrary {
        /// <summary>
        /// Mask which indicate whole of the cell is occupied
        /// </summary>
        static public readonly ushort FullCellMask = 0xffff;

        /// <summary>
        /// returns mask which indicate diagonal half triangle of the cell is occupied.
        /// </summary>
        /// <param name="dir">the Direction which vortex of the cell is fully occupied.</param>
        /// <returns></returns>
        static public ushort GetCellDiagonalMask(InterCardinalDirection dir) {
            int i = Direction.ToZeroBaseIndex(dir);
            return halfMasks[i];
        }

        static public ushort GetCellEdgeMask(Direction4 dir) {
            int i = (int)dir;
            return quarterMasks[i];
        }

        static private readonly ushort[] halfMasks;
        static private readonly ushort[] quarterMasks;
        static OccupationMaskLibrary() {
            halfMasks = new ushort[4];
            halfMasks[Direction.ToZeroBaseIndex(InterCardinalDirection.NORTHWEST)] = 0x3fc0;
            halfMasks[Direction.ToZeroBaseIndex(InterCardinalDirection.NORTHEAST)] = 0x03fc;
            halfMasks[Direction.ToZeroBaseIndex(InterCardinalDirection.SOUTHEAST)] = 0xc03f;
            halfMasks[Direction.ToZeroBaseIndex(InterCardinalDirection.SOUTHWEST)] = 0xfc03;
            quarterMasks = new ushort[4];
            quarterMasks[(int)(Direction4.EAST)] = 0x003c;
            quarterMasks[(int)(Direction4.NORTH)] = 0x03c0;
            quarterMasks[(int)(Direction4.SOUTH)] = 0xc003;
            quarterMasks[(int)(Direction4.WEST)] = 0x3c00;
        }

    }
}
